/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.metadata.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.MetadataProviderContainer;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.service.ServiceException;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.opensaml.saml.metadata.resolver.ChainingMetadataResolver;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.context.ApplicationContext;

public class MetadataResolverServiceStrategy
extends AbstractIdentifiableInitializableComponent
implements Function<ApplicationContext, ServiceableComponent<MetadataResolver>> {
    @Override
    @Nullable
    public ServiceableComponent<MetadataResolver> apply(@Nullable ApplicationContext appContext) {
        Collection containers = appContext.getBeansOfType(MetadataProviderContainer.class).values();
        if (containers.isEmpty()) {
            throw new ServiceException("Reload did not produce any bean of type" + MetadataProviderContainer.class.getName());
        }
        if (1 == containers.size()) {
            return (ServiceableComponent)containers.iterator().next();
        }
        for (MetadataProviderContainer resolver : containers) {
            try {
                resolver.initialize();
            }
            catch (ComponentInitializationException e) {
                throw new BeanCreationException("could not preinitialize , metadata provider " + resolver.getId(), (Throwable)e);
            }
        }
        ArrayList containerList = new ArrayList(containers.size());
        containerList.addAll(containers);
        Collections.sort(containerList);
        ChainingMetadataResolver chain = new ChainingMetadataResolver();
        try {
            chain.setResolvers(containerList.stream().map(MetadataProviderContainer::getEmbeddedResolver).collect(Collectors.toList()));
            chain.setId("MultiFileResolverFor:" + containers.size() + ":Resources");
            chain.initialize();
            MetadataProviderContainer result = new MetadataProviderContainer();
            result.setEmbeddedResolver((MetadataResolver)chain);
            result.setApplicationContext(appContext);
            result.initialize();
            return result;
        }
        catch (ComponentInitializationException | ResolverException e) {
            throw new ServiceException("Chaining constructor create failed", (Exception)e);
        }
    }
}

