/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.metadata.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.saml.metadata.resolver.ChainingMetadataResolver;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterChain;
import org.opensaml.saml.metadata.resolver.filter.MetadataNodeProcessor;
import org.opensaml.saml.metadata.resolver.filter.impl.NodeProcessingMetadataFilter;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;

public class NodeProcessingAttachingBeanPostProcessor
implements BeanPostProcessor,
Ordered {
    @Nonnull
    @NonnullElements
    private List<MetadataNodeProcessor> nodeProcessors;

    @Autowired
    public NodeProcessingAttachingBeanPostProcessor(@Nullable @NonnullElements Collection<MetadataNodeProcessor> processors) {
        this.nodeProcessors = processors != null ? List.copyOf(processors) : Collections.emptyList();
    }

    public void setNodeProcessors(@Nullable @NonnullElements Collection<MetadataNodeProcessor> processors) {
        if (processors != null) {
            this.nodeProcessors = List.copyOf(processors);
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        if (this.nodeProcessors.isEmpty()) {
            return bean;
        }
        if (!(bean instanceof MetadataResolver) || bean instanceof ChainingMetadataResolver) {
            return bean;
        }
        MetadataResolver resolver = (MetadataResolver)bean;
        NodeProcessingMetadataFilter filterToAttach = new NodeProcessingMetadataFilter();
        filterToAttach.setNodeProcessors(this.nodeProcessors);
        try {
            filterToAttach.initialize();
        }
        catch (ComponentInitializationException e) {
            throw new BeanCreationException("Error initializing NodeProcessingMetadataFilter", (Throwable)e);
        }
        MetadataFilter filter = resolver.getMetadataFilter();
        if (filter == null) {
            resolver.setMetadataFilter((MetadataFilter)filterToAttach);
        } else if (filter instanceof MetadataFilterChain) {
            ((MetadataFilterChain)filter).getFilters().add(filterToAttach);
        } else {
            MetadataFilterChain chain = new MetadataFilterChain();
            chain.setFilters(List.of(filter, filterToAttach));
            resolver.setMetadataFilter((MetadataFilter)chain);
        }
        return resolver;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        return bean;
    }
}

