/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.security.trustengine.impl;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.idp.profile.spring.relyingparty.security.trustengine.impl.AbstractTrustEngineParser;
import net.shibboleth.idp.profile.spring.relyingparty.security.trustengine.impl.PKIXValidationOptionsParser;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.opensaml.security.x509.impl.BasicX509CredentialNameEvaluator;
import org.opensaml.security.x509.impl.CertPathPKIXTrustEvaluator;
import org.opensaml.security.x509.impl.StaticPKIXValidationInformationResolver;
import org.opensaml.security.x509.impl.X509CredentialNameEvaluator;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractStaticPKIXParser
extends AbstractTrustEngineParser {
    public static final QName VALIDATION_INFO = new QName("urn:mace:shibboleth:2.0:security", "ValidationInfo");
    public static final QName TRUSTED_NAMES = new QName("urn:mace:shibboleth:2.0:security", "TrustedName");

    protected BeanDefinition getPKIXValidationInformationResolver(@Nonnull Element element, @Nonnull ParserContext parserContext) {
        List validationInfoElements = ElementSupport.getChildElements((Node)element, (QName)VALIDATION_INFO);
        List trustedNameElements = ElementSupport.getChildElements((Node)element, (QName)TRUSTED_NAMES);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(StaticPKIXValidationInformationResolver.class);
        builder.addConstructorArgValue((Object)SpringSupport.parseCustomElements((Collection)validationInfoElements, (ParserContext)parserContext, (BeanDefinitionBuilder)builder));
        builder.addConstructorArgValue((Object)SpringSupport.getElementTextContentAsManagedList((Collection)trustedNameElements));
        return builder.getBeanDefinition();
    }

    protected BeanDefinition getPKIXTrustEvaluator(@Nonnull Element element, @Nonnull ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CertPathPKIXTrustEvaluator.class);
        List validationOptionsElements = ElementSupport.getChildElements((Node)element, (QName)PKIXValidationOptionsParser.ELEMENT_NAME);
        if (null != validationOptionsElements && !validationOptionsElements.isEmpty()) {
            builder.addConstructorArgValue((Object)SpringSupport.parseCustomElements((Collection)validationOptionsElements, (ParserContext)parserContext, (BeanDefinitionBuilder)builder));
        }
        return builder.getBeanDefinition();
    }

    protected Object getX509CredentialNameEvaluator(@Nonnull Element element, @Nonnull ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(X509CredentialNameEvaluatorFactoryBean.class);
        String attrValue = StringSupport.trimOrNull((String)element.getAttributeNS(null, "trustedNameCheckEnabled"));
        if (attrValue != null) {
            builder.addPropertyValue("trustedNameCheckEnabled", (Object)attrValue);
        }
        return builder.getBeanDefinition();
    }

    protected static class X509CredentialNameEvaluatorFactoryBean
    extends AbstractFactoryBean<X509CredentialNameEvaluator> {
        private boolean trustedNameCheckEnabled = true;

        protected X509CredentialNameEvaluatorFactoryBean() {
        }

        public void setTrustedNameCheckEnabled(boolean enabled) {
            this.trustedNameCheckEnabled = enabled;
        }

        public Class<?> getObjectType() {
            return BasicX509CredentialNameEvaluator.class;
        }

        protected BasicX509CredentialNameEvaluator createInstance() throws Exception {
            if (this.trustedNameCheckEnabled) {
                return new BasicX509CredentialNameEvaluator();
            }
            return null;
        }
    }
}

