/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.factory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.shibboleth.ext.spring.context.FilesystemGenericApplicationContext;
import net.shibboleth.ext.spring.context.FilesystemGenericWebApplicationContext;
import net.shibboleth.ext.spring.util.SchemaTypeAwareXMLBeanDefinitionReader;
import net.shibboleth.idp.profile.spring.factory.FlowRelativeResourceLoader;
import net.shibboleth.idp.profile.spring.factory.LocalFlowBuilderContext;
import net.shibboleth.idp.profile.spring.factory.SubflowExpression;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.binding.convert.ConversionExecutionException;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.service.RuntimeBindingConversionExecutor;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.expression.ParserContext;
import org.springframework.binding.expression.support.FluentParserContext;
import org.springframework.binding.mapping.Mapper;
import org.springframework.binding.mapping.impl.DefaultMapper;
import org.springframework.binding.mapping.impl.DefaultMapping;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestScope;
import org.springframework.webflow.action.EvaluateAction;
import org.springframework.webflow.action.ExternalRedirectAction;
import org.springframework.webflow.action.FlowDefinitionRedirectAction;
import org.springframework.webflow.action.RenderAction;
import org.springframework.webflow.action.SetAction;
import org.springframework.webflow.action.ViewFactoryActionAdapter;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.FlowExecutionExceptionHandler;
import org.springframework.webflow.engine.FlowVariable;
import org.springframework.webflow.engine.History;
import org.springframework.webflow.engine.SubflowAttributeMapper;
import org.springframework.webflow.engine.TargetStateResolver;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.TransitionCriteria;
import org.springframework.webflow.engine.VariableValueFactory;
import org.springframework.webflow.engine.ViewVariable;
import org.springframework.webflow.engine.builder.BinderConfiguration;
import org.springframework.webflow.engine.builder.FlowBuilderException;
import org.springframework.webflow.engine.builder.support.AbstractFlowBuilder;
import org.springframework.webflow.engine.model.AbstractActionModel;
import org.springframework.webflow.engine.model.AbstractMappingModel;
import org.springframework.webflow.engine.model.AbstractStateModel;
import org.springframework.webflow.engine.model.ActionStateModel;
import org.springframework.webflow.engine.model.AttributeModel;
import org.springframework.webflow.engine.model.BeanImportModel;
import org.springframework.webflow.engine.model.BinderModel;
import org.springframework.webflow.engine.model.BindingModel;
import org.springframework.webflow.engine.model.DecisionStateModel;
import org.springframework.webflow.engine.model.EndStateModel;
import org.springframework.webflow.engine.model.EvaluateModel;
import org.springframework.webflow.engine.model.ExceptionHandlerModel;
import org.springframework.webflow.engine.model.FlowModel;
import org.springframework.webflow.engine.model.IfModel;
import org.springframework.webflow.engine.model.InputModel;
import org.springframework.webflow.engine.model.OutputModel;
import org.springframework.webflow.engine.model.PersistenceContextModel;
import org.springframework.webflow.engine.model.RenderModel;
import org.springframework.webflow.engine.model.SecuredModel;
import org.springframework.webflow.engine.model.SetModel;
import org.springframework.webflow.engine.model.SubflowStateModel;
import org.springframework.webflow.engine.model.TransitionModel;
import org.springframework.webflow.engine.model.VarModel;
import org.springframework.webflow.engine.model.ViewStateModel;
import org.springframework.webflow.engine.model.builder.FlowModelBuilderException;
import org.springframework.webflow.engine.model.registry.FlowModelHolder;
import org.springframework.webflow.engine.support.ActionExecutingViewFactory;
import org.springframework.webflow.engine.support.BeanFactoryVariableValueFactory;
import org.springframework.webflow.engine.support.DefaultTransitionCriteria;
import org.springframework.webflow.engine.support.GenericSubflowAttributeMapper;
import org.springframework.webflow.engine.support.TransitionCriteriaChain;
import org.springframework.webflow.engine.support.TransitionExecutingFlowExecutionExceptionHandler;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.AnnotatedAction;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ViewFactory;
import org.springframework.webflow.scope.ConversationScope;
import org.springframework.webflow.scope.FlashScope;
import org.springframework.webflow.scope.FlowScope;
import org.springframework.webflow.scope.ViewScope;
import org.springframework.webflow.security.SecurityRule;

public class FlowModelFlowBuilder
extends AbstractFlowBuilder {
    private static final boolean IS_SPRING_FACES_PRESENT = ClassUtils.isPresent((String)"org.springframework.faces.webflow.FlowActionListener", (ClassLoader)FlowModelFlowBuilder.class.getClassLoader());
    public static final String VALIDATOR_FLOW_ATTR = FlowModelFlowBuilder.class.getSimpleName() + ".validator";
    public static final String VALIDATION_HINT_RESOLVER_FLOW_ATTR = FlowModelFlowBuilder.class.getSimpleName() + ".validationHintResolver";
    private FlowModelHolder flowModelHolder;
    private FlowModel flowModel;
    private LocalFlowBuilderContext localFlowBuilderContext;

    public FlowModelFlowBuilder(FlowModelHolder flowModelHolder) {
        Assert.notNull((Object)flowModelHolder, (String)"The FlowModelHolder is required");
        this.flowModelHolder = flowModelHolder;
    }

    protected void doInit() throws FlowBuilderException {
        try {
            this.flowModel = this.flowModelHolder.getFlowModel();
            this.initLocalFlowContext();
        }
        catch (FlowModelBuilderException e) {
            throw new FlowBuilderException("Unable to get the model for this flow", (Throwable)e);
        }
        if ("true".equals(this.flowModel.getAbstract())) {
            throw new FlowBuilderException("Abstract flow models cannot be instantiated.");
        }
    }

    protected Flow createFlow() {
        String flowId = this.getContext().getFlowId();
        AttributeMap flowAttributes = this.parseFlowMetaAttributes(this.flowModel);
        flowAttributes = this.getContext().getFlowAttributes().union(flowAttributes);
        if (IS_SPRING_FACES_PRESENT) {
            flowAttributes.asMap().put(VALIDATOR_FLOW_ATTR, this.getLocalContext().getValidator());
            flowAttributes.asMap().put(VALIDATION_HINT_RESOLVER_FLOW_ATTR, this.getLocalContext().getValidationHintResolver());
        }
        Flow flow = this.getLocalContext().getFlowArtifactFactory().createFlow(flowId, flowAttributes);
        flow.setApplicationContext(this.getLocalContext().getApplicationContext());
        return flow;
    }

    public void buildVariables() throws FlowBuilderException {
        if (this.flowModel.getVars() != null) {
            for (VarModel varModel : this.flowModel.getVars()) {
                this.getFlow().addVariable(this.parseFlowVariable(varModel));
            }
        }
    }

    public void buildInputMapper() throws FlowBuilderException {
        this.getFlow().setInputMapper(this.parseFlowInputMapper(this.flowModel.getInputs()));
    }

    public void buildStartActions() throws FlowBuilderException {
        this.getFlow().getStartActionList().addAll(this.parseActions(this.flowModel.getOnStartActions()));
    }

    public void buildStates() throws FlowBuilderException {
        if (this.flowModel.getStates() == null) {
            throw new FlowBuilderException("At least one state is required to build a Flow");
        }
        for (AbstractStateModel state : this.flowModel.getStates()) {
            if (state instanceof ActionStateModel) {
                this.parseAndAddActionState((ActionStateModel)state, this.getFlow());
                continue;
            }
            if (state instanceof ViewStateModel) {
                this.parseAndAddViewState((ViewStateModel)state, this.getFlow());
                continue;
            }
            if (state instanceof DecisionStateModel) {
                this.parseAndAddDecisionState((DecisionStateModel)state, this.getFlow());
                continue;
            }
            if (state instanceof SubflowStateModel) {
                this.parseAndAddSubflowState((SubflowStateModel)state, this.getFlow());
                continue;
            }
            if (!(state instanceof EndStateModel)) continue;
            this.parseAndAddEndState((EndStateModel)state, this.getFlow());
        }
        if (this.flowModel.getStartStateId() != null) {
            this.getFlow().setStartState(this.flowModel.getStartStateId());
        }
    }

    public void buildGlobalTransitions() throws FlowBuilderException {
        this.getFlow().getGlobalTransitionSet().addAll(this.parseTransitions(this.flowModel.getGlobalTransitions()));
    }

    public void buildEndActions() throws FlowBuilderException {
        this.getFlow().getEndActionList().addAll(this.parseActions(this.flowModel.getOnEndActions()));
    }

    public void buildOutputMapper() throws FlowBuilderException {
        if (this.flowModel.getOutputs() != null) {
            this.getFlow().setOutputMapper(this.parseFlowOutputMapper(this.flowModel.getOutputs()));
        }
    }

    public void buildExceptionHandlers() throws FlowBuilderException {
        this.getFlow().getExceptionHandlerSet().addAll(this.parseExceptionHandlers(this.flowModel.getExceptionHandlers(), this.flowModel.getGlobalTransitions()));
    }

    public boolean hasFlowChanged() {
        return this.flowModelHolder.hasFlowModelChanged();
    }

    public String getFlowResourceString() {
        return this.flowModelHolder.getFlowModelResource().getDescription();
    }

    protected void doDispose() throws FlowBuilderException {
        this.flowModel = null;
        this.setLocalContext(null);
    }

    protected FlowModel getFlowModel() {
        return this.flowModel;
    }

    protected LocalFlowBuilderContext getLocalContext() {
        return this.localFlowBuilderContext;
    }

    protected void setLocalContext(LocalFlowBuilderContext localFlowBuilderContext) {
        this.localFlowBuilderContext = localFlowBuilderContext;
    }

    protected void registerFlowBeans(ConfigurableBeanFactory beanFactory) {
    }

    private void initLocalFlowContext() {
        String[] contextResources = this.parseContextResources(this.getFlowModel().getBeanImports());
        GenericApplicationContext flowContext = this.createFlowApplicationContext(contextResources);
        this.setLocalContext(new LocalFlowBuilderContext(this.getContext(), flowContext));
    }

    private String[] parseContextResources(List<BeanImportModel> beanImports) {
        if (beanImports != null && !beanImports.isEmpty()) {
            String[] resources = new String[beanImports.size()];
            return beanImports.stream().map(BeanImportModel::getResource).collect(Collectors.toUnmodifiableList()).toArray(resources);
        }
        return new String[0];
    }

    private GenericApplicationContext createFlowApplicationContext(String[] resources) {
        FilesystemGenericApplicationContext flowContext;
        ApplicationContext parent = this.getContext().getApplicationContext();
        if (parent instanceof WebApplicationContext) {
            FilesystemGenericWebApplicationContext webContext = new FilesystemGenericWebApplicationContext();
            webContext.setServletContext(((WebApplicationContext)parent).getServletContext());
            flowContext = webContext;
        } else {
            flowContext = new FilesystemGenericApplicationContext();
        }
        flowContext.setDisplayName("Flow ApplicationContext [" + this.getContext().getFlowId() + "]");
        flowContext.setParent(parent);
        flowContext.getBeanFactory().registerScope("request", (Scope)new RequestScope());
        flowContext.getBeanFactory().registerScope("flash", (Scope)new FlashScope());
        flowContext.getBeanFactory().registerScope("view", (Scope)new ViewScope());
        flowContext.getBeanFactory().registerScope("flow", (Scope)new FlowScope());
        flowContext.getBeanFactory().registerScope("conversation", (Scope)new ConversationScope());
        ClassLoader classLoaderToUse = flowContext.getClassLoader();
        flowContext.setClassLoader(classLoaderToUse);
        Resource flowResource = this.flowModelHolder.getFlowModelResource();
        flowContext.setResourceLoader((ResourceLoader)new FlowRelativeResourceLoader(flowResource));
        flowContext.getEnvironment().setPlaceholderPrefix("%{");
        flowContext.getEnvironment().setPlaceholderSuffix("}");
        AnnotationConfigUtils.registerAnnotationConfigProcessors((BeanDefinitionRegistry)flowContext);
        new SchemaTypeAwareXMLBeanDefinitionReader((BeanDefinitionRegistry)flowContext).loadBeanDefinitions(resources);
        this.registerFlowBeans((ConfigurableBeanFactory)flowContext.getBeanFactory());
        this.registerMessageSource((GenericApplicationContext)flowContext, flowResource);
        flowContext.refresh();
        return flowContext;
    }

    private boolean isFlowInDevelopment() {
        return this.getContext().getFlowAttributes().getBoolean("development", Boolean.valueOf(false));
    }

    private void registerMessageSource(GenericApplicationContext flowContext, Resource flowResource) {
        boolean localMessageSourcePresent = flowContext.containsLocalBean("messageSource");
        if (!localMessageSourcePresent) {
            Resource messageBundle;
            try {
                messageBundle = flowResource.createRelative("messages.properties");
            }
            catch (IOException e) {
                messageBundle = null;
            }
            if (messageBundle != null && messageBundle.exists()) {
                BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ReloadableResourceBundleMessageSource.class);
                builder.addPropertyValue("basename", (Object)"messages");
                if (this.isFlowInDevelopment()) {
                    builder.addPropertyValue("cacheSeconds", (Object)"0");
                }
                flowContext.registerBeanDefinition("messageSource", (BeanDefinition)builder.getBeanDefinition());
            }
        }
    }

    private AttributeMap<Object> parseFlowMetaAttributes(FlowModel flow) {
        MutableAttributeMap<Object> flowAttributes = this.parseMetaAttributes(flow.getAttributes());
        this.parseAndPutPersistenceContext(flow.getPersistenceContext(), flowAttributes);
        this.parseAndPutSecured(flow.getSecured(), flowAttributes);
        return flowAttributes;
    }

    private FlowVariable parseFlowVariable(VarModel var) {
        Class<?> clazz = this.toClass(var.getClassName());
        BeanFactoryVariableValueFactory valueFactory = new BeanFactoryVariableValueFactory(clazz, this.getFlow().getApplicationContext().getAutowireCapableBeanFactory());
        return new FlowVariable(var.getName(), (VariableValueFactory)valueFactory);
    }

    private Mapper parseFlowInputMapper(List<InputModel> inputs) {
        if (inputs != null && !inputs.isEmpty()) {
            DefaultMapper inputMapper = new DefaultMapper();
            for (InputModel inputModel : inputs) {
                inputMapper.addMapping(this.parseFlowInputMapping(inputModel));
            }
            return inputMapper;
        }
        return null;
    }

    private DefaultMapping parseFlowInputMapping(InputModel input) {
        ExpressionParser parser = this.getLocalContext().getExpressionParser();
        String name = input.getName();
        Object value = null;
        value = StringUtils.hasText((String)input.getValue()) ? input.getValue() : "flowScope." + name;
        Expression source = parser.parseExpression(name, (ParserContext)new FluentParserContext().evaluate(MutableAttributeMap.class));
        Expression target = parser.parseExpression((String)value, (ParserContext)new FluentParserContext().evaluate(RequestContext.class));
        DefaultMapping mapping = new DefaultMapping(source, target);
        this.parseAndSetMappingConversionExecutor((AbstractMappingModel)input, mapping);
        this.parseAndSetMappingRequired((AbstractMappingModel)input, mapping);
        return mapping;
    }

    private Mapper parseSubflowInputMapper(List<InputModel> inputs) {
        if (inputs != null && !inputs.isEmpty()) {
            DefaultMapper inputMapper = new DefaultMapper();
            for (InputModel inputModel : inputs) {
                inputMapper.addMapping(this.parseSubflowInputMapping(inputModel));
            }
            return inputMapper;
        }
        return null;
    }

    private DefaultMapping parseSubflowInputMapping(InputModel input) {
        ExpressionParser parser = this.getLocalContext().getExpressionParser();
        String name = input.getName();
        String value = null;
        value = StringUtils.hasText((String)input.getValue()) ? input.getValue() : name;
        Expression source = parser.parseExpression(value, (ParserContext)new FluentParserContext().evaluate(RequestContext.class));
        Expression target = parser.parseExpression(name, (ParserContext)new FluentParserContext().evaluate(MutableAttributeMap.class));
        DefaultMapping mapping = new DefaultMapping(source, target);
        this.parseAndSetMappingConversionExecutor((AbstractMappingModel)input, mapping);
        this.parseAndSetMappingRequired((AbstractMappingModel)input, mapping);
        return mapping;
    }

    private Mapper parseFlowOutputMapper(List<OutputModel> outputs) {
        if (outputs != null && !outputs.isEmpty()) {
            DefaultMapper outputMapper = new DefaultMapper();
            for (OutputModel outputModel : outputs) {
                outputMapper.addMapping(this.parseFlowOutputMapping(outputModel));
            }
            return outputMapper;
        }
        return null;
    }

    private DefaultMapping parseFlowOutputMapping(OutputModel output) {
        ExpressionParser parser = this.getLocalContext().getExpressionParser();
        String name = output.getName();
        String value = null;
        value = StringUtils.hasText((String)output.getValue()) ? output.getValue() : name;
        Expression source = parser.parseExpression(value, (ParserContext)new FluentParserContext().evaluate(RequestContext.class));
        Expression target = parser.parseExpression(name, (ParserContext)new FluentParserContext().evaluate(MutableAttributeMap.class));
        DefaultMapping mapping = new DefaultMapping(source, target);
        this.parseAndSetMappingConversionExecutor((AbstractMappingModel)output, mapping);
        this.parseAndSetMappingRequired((AbstractMappingModel)output, mapping);
        return mapping;
    }

    private Mapper parseSubflowOutputMapper(List<OutputModel> outputs) {
        if (outputs != null && !outputs.isEmpty()) {
            DefaultMapper outputMapper = new DefaultMapper();
            for (OutputModel outputModel : outputs) {
                outputMapper.addMapping(this.parseSubflowOutputMapping(outputModel));
            }
            return outputMapper;
        }
        return null;
    }

    private DefaultMapping parseSubflowOutputMapping(OutputModel output) {
        ExpressionParser parser = this.getLocalContext().getExpressionParser();
        String name = output.getName();
        Object value = null;
        value = StringUtils.hasText((String)output.getValue()) ? output.getValue() : "flowScope." + name;
        Expression source = parser.parseExpression(name, (ParserContext)new FluentParserContext().evaluate(MutableAttributeMap.class));
        Expression target = parser.parseExpression((String)value, (ParserContext)new FluentParserContext().evaluate(RequestContext.class));
        DefaultMapping mapping = new DefaultMapping(source, target);
        this.parseAndSetMappingConversionExecutor((AbstractMappingModel)output, mapping);
        this.parseAndSetMappingRequired((AbstractMappingModel)output, mapping);
        return mapping;
    }

    private void parseAndSetMappingConversionExecutor(AbstractMappingModel mappingModel, DefaultMapping mapping) {
        if (StringUtils.hasText((String)mappingModel.getType())) {
            Class<?> type = this.toClass(mappingModel.getType());
            RuntimeBindingConversionExecutor typeConverter = new RuntimeBindingConversionExecutor(type, this.getLocalContext().getConversionService());
            mapping.setTypeConverter((ConversionExecutor)typeConverter);
        }
    }

    private void parseAndSetMappingRequired(AbstractMappingModel mappingModel, DefaultMapping mapping) {
        if (StringUtils.hasText((String)mappingModel.getRequired())) {
            boolean required = (Boolean)this.fromStringTo(Boolean.class).execute((Object)mappingModel.getRequired());
            mapping.setRequired(required);
        }
    }

    private void parseAndAddViewState(ViewStateModel state, Flow flow) {
        ViewFactory viewFactory = this.parseViewFactory(state.getView(), state.getId(), false, state.getBinder());
        Boolean redirect = null;
        if (StringUtils.hasText((String)state.getRedirect())) {
            redirect = (Boolean)this.fromStringTo(Boolean.class).execute((Object)state.getRedirect());
        }
        boolean popup = false;
        if (StringUtils.hasText((String)state.getPopup())) {
            popup = (Boolean)this.fromStringTo(Boolean.class).execute((Object)state.getPopup());
        }
        MutableAttributeMap<Object> attributes = this.parseMetaAttributes(state.getAttributes());
        if (state.getModel() != null) {
            attributes.put("model", (Object)this.getLocalContext().getExpressionParser().parseExpression(state.getModel(), (ParserContext)new FluentParserContext().evaluate(RequestContext.class)));
        }
        if (state.getValidationHints() != null) {
            attributes.put("validationHints", (Object)this.getLocalContext().getExpressionParser().parseExpression(state.getValidationHints(), (ParserContext)new FluentParserContext().evaluate(RequestContext.class)));
        }
        this.parseAndPutSecured(state.getSecured(), attributes);
        this.getLocalContext().getFlowArtifactFactory().createViewState(state.getId(), flow, this.parseViewVariables(state.getVars()), this.parseActions(state.getOnEntryActions()), viewFactory, redirect, popup, this.parseActions(state.getOnRenderActions()), this.parseTransitions(state.getTransitions()), this.parseExceptionHandlers(state.getExceptionHandlers(), state.getTransitions()), this.parseActions(state.getOnExitActions()), attributes);
    }

    private void parseAndAddActionState(ActionStateModel state, Flow flow) {
        MutableAttributeMap<Object> attributes = this.parseMetaAttributes(state.getAttributes());
        this.parseAndPutSecured(state.getSecured(), attributes);
        this.getLocalContext().getFlowArtifactFactory().createActionState(state.getId(), flow, this.parseActions(state.getOnEntryActions()), this.parseActions(state.getActions()), this.parseTransitions(state.getTransitions()), this.parseExceptionHandlers(state.getExceptionHandlers(), state.getTransitions()), this.parseActions(state.getOnExitActions()), attributes);
    }

    private void parseAndAddDecisionState(DecisionStateModel state, Flow flow) {
        MutableAttributeMap<Object> attributes = this.parseMetaAttributes(state.getAttributes());
        this.parseAndPutSecured(state.getSecured(), attributes);
        this.getLocalContext().getFlowArtifactFactory().createDecisionState(state.getId(), flow, this.parseActions(state.getOnEntryActions()), this.parseIfs(state.getIfs()), this.parseExceptionHandlers(state.getExceptionHandlers(), null), this.parseActions(state.getOnExitActions()), attributes);
    }

    private void parseAndAddSubflowState(SubflowStateModel state, Flow flow) {
        MutableAttributeMap<Object> attributes = this.parseMetaAttributes(state.getAttributes());
        this.parseAndPutSecured(state.getSecured(), attributes);
        this.getLocalContext().getFlowArtifactFactory().createSubflowState(state.getId(), flow, this.parseActions(state.getOnEntryActions()), this.parseSubflowExpression(state.getSubflow()), this.parseSubflowAttributeMapper(state), this.parseTransitions(state.getTransitions()), this.parseExceptionHandlers(state.getExceptionHandlers(), state.getTransitions()), this.parseActions(state.getOnExitActions()), attributes);
    }

    private void parseAndAddEndState(EndStateModel state, Flow flow) {
        MutableAttributeMap<Object> attributes = this.parseMetaAttributes(state.getAttributes());
        if (StringUtils.hasText((String)state.getCommit())) {
            attributes.put("commit", this.fromStringTo(Boolean.class).execute((Object)state.getCommit()));
        }
        this.parseAndPutSecured(state.getSecured(), attributes);
        ViewFactory viewFactory = this.parseViewFactory(state.getView(), state.getId(), true, null);
        ViewFactoryActionAdapter finalResponseAction = viewFactory != null ? new ViewFactoryActionAdapter(viewFactory) : null;
        this.getLocalContext().getFlowArtifactFactory().createEndState(state.getId(), flow, this.parseActions(state.getOnEntryActions()), (Action)finalResponseAction, this.parseFlowOutputMapper(state.getOutputs()), this.parseExceptionHandlers(state.getExceptionHandlers(), null), attributes);
    }

    private ViewFactory parseViewFactory(String view, String stateId, boolean endState, BinderModel binderModel) {
        if (!StringUtils.hasText((String)view)) {
            if (endState) {
                return null;
            }
            view = this.getLocalContext().getViewFactoryCreator().getViewIdByConvention(stateId);
            Expression viewId = this.getLocalContext().getExpressionParser().parseExpression(view, (ParserContext)new FluentParserContext().template().evaluate(RequestContext.class).expectResult(String.class));
            return this.createViewFactory(viewId, binderModel);
        }
        if (view.startsWith("externalRedirect:")) {
            String encodedUrl = view.substring("externalRedirect:".length());
            Expression externalUrl = this.getLocalContext().getExpressionParser().parseExpression(encodedUrl, (ParserContext)new FluentParserContext().template().evaluate(RequestContext.class).expectResult(String.class));
            return new ActionExecutingViewFactory((Action)new ExternalRedirectAction(externalUrl));
        }
        if (view.startsWith("flowRedirect:")) {
            String flowRedirect = view.substring("flowRedirect:".length());
            Expression expression = this.getLocalContext().getExpressionParser().parseExpression(flowRedirect, (ParserContext)new FluentParserContext().template().evaluate(RequestContext.class).expectResult(String.class));
            return new ActionExecutingViewFactory((Action)new FlowDefinitionRedirectAction(expression));
        }
        Expression viewId = this.getLocalContext().getExpressionParser().parseExpression(view, (ParserContext)new FluentParserContext().template().evaluate(RequestContext.class).expectResult(String.class));
        return this.createViewFactory(viewId, binderModel);
    }

    private ViewFactory createViewFactory(Expression viewId, BinderModel binderModel) {
        BinderConfiguration binderConfiguration = this.createBinderConfiguration(binderModel);
        return this.getLocalContext().getViewFactoryCreator().createViewFactory(viewId, this.getLocalContext().getExpressionParser(), this.getLocalContext().getConversionService(), binderConfiguration, this.getLocalContext().getValidator(), this.getLocalContext().getValidationHintResolver());
    }

    private BinderConfiguration createBinderConfiguration(BinderModel binderModel) {
        if (binderModel != null && binderModel.getBindings() != null) {
            BinderConfiguration binderConfiguration = new BinderConfiguration();
            LinkedList bindings = binderModel.getBindings();
            for (BindingModel bindingModel : bindings) {
                boolean required = false;
                if (StringUtils.hasText((String)bindingModel.getRequired())) {
                    required = (Boolean)this.fromStringTo(Boolean.class).execute((Object)bindingModel.getRequired());
                }
                BinderConfiguration.Binding binding = new BinderConfiguration.Binding(bindingModel.getProperty(), bindingModel.getConverter(), required);
                binderConfiguration.addBinding(binding);
            }
            return binderConfiguration;
        }
        return null;
    }

    private ViewVariable[] parseViewVariables(List<VarModel> vars) {
        if (vars != null && !vars.isEmpty()) {
            ArrayList<ViewVariable> variables = new ArrayList<ViewVariable>(vars.size());
            for (VarModel varModel : vars) {
                variables.add(this.parseViewVariable(varModel));
            }
            return variables.toArray(new ViewVariable[variables.size()]);
        }
        return new ViewVariable[0];
    }

    private ViewVariable parseViewVariable(VarModel var) {
        Class<?> clazz = this.toClass(var.getClassName());
        BeanFactoryVariableValueFactory valueFactory = new BeanFactoryVariableValueFactory(clazz, this.getFlow().getApplicationContext().getAutowireCapableBeanFactory());
        return new ViewVariable(var.getName(), (VariableValueFactory)valueFactory);
    }

    private Transition[] parseIfs(List<IfModel> ifModels) {
        if (ifModels != null && !ifModels.isEmpty()) {
            ArrayList<Transition> transitions = new ArrayList<Transition>(ifModels.size());
            for (IfModel ifModel : ifModels) {
                transitions.addAll(Arrays.asList(this.parseIf(ifModel)));
            }
            return transitions.toArray(new Transition[transitions.size()]);
        }
        return new Transition[0];
    }

    private Transition[] parseIf(IfModel ifModel) {
        Transition thenTransition = this.parseThen(ifModel);
        if (StringUtils.hasText((String)ifModel.getElse())) {
            Transition elseTransition = this.parseElse(ifModel);
            return new Transition[]{thenTransition, elseTransition};
        }
        return new Transition[]{thenTransition};
    }

    private Transition parseThen(IfModel ifModel) {
        Expression test = this.getLocalContext().getExpressionParser().parseExpression(ifModel.getTest(), (ParserContext)new FluentParserContext().evaluate(RequestContext.class).expectResult(Boolean.class));
        DefaultTransitionCriteria matchingCriteria = new DefaultTransitionCriteria(test);
        TargetStateResolver targetStateResolver = (TargetStateResolver)this.fromStringTo(TargetStateResolver.class).execute((Object)ifModel.getThen());
        return this.getLocalContext().getFlowArtifactFactory().createTransition(targetStateResolver, (TransitionCriteria)matchingCriteria, null, null);
    }

    private Transition parseElse(IfModel ifModel) {
        TargetStateResolver stateResolver = (TargetStateResolver)this.fromStringTo(TargetStateResolver.class).execute((Object)ifModel.getElse());
        return this.getLocalContext().getFlowArtifactFactory().createTransition(stateResolver, null, null, null);
    }

    private Expression parseSubflowExpression(String subflow) {
        Expression subflowId = this.getLocalContext().getExpressionParser().parseExpression(subflow, (ParserContext)new FluentParserContext().template().evaluate(RequestContext.class).expectResult(String.class));
        return new SubflowExpression(subflowId, this.getLocalContext().getFlowDefinitionLocator());
    }

    private SubflowAttributeMapper parseSubflowAttributeMapper(SubflowStateModel state) {
        if (StringUtils.hasText((String)state.getSubflowAttributeMapper())) {
            String beanId = state.getSubflowAttributeMapper();
            return (SubflowAttributeMapper)this.getLocalContext().getApplicationContext().getBean(beanId, SubflowAttributeMapper.class);
        }
        Mapper inputMapper = this.parseSubflowInputMapper(state.getInputs());
        Mapper outputMapper = this.parseSubflowOutputMapper(state.getOutputs());
        return new GenericSubflowAttributeMapper(inputMapper, outputMapper);
    }

    private FlowExecutionExceptionHandler[] parseExceptionHandlers(List<ExceptionHandlerModel> modelExceptionHandlers, List<TransitionModel> modelTransitions) {
        FlowExecutionExceptionHandler[] transitionExecutingHandlers = this.parseTransitionExecutingExceptionHandlers(modelTransitions);
        FlowExecutionExceptionHandler[] customHandlers = this.parseCustomExceptionHandlers(modelExceptionHandlers);
        FlowExecutionExceptionHandler[] exceptionHandlers = new FlowExecutionExceptionHandler[transitionExecutingHandlers.length + customHandlers.length];
        System.arraycopy(transitionExecutingHandlers, 0, exceptionHandlers, 0, transitionExecutingHandlers.length);
        System.arraycopy(customHandlers, 0, exceptionHandlers, transitionExecutingHandlers.length, customHandlers.length);
        return exceptionHandlers;
    }

    private FlowExecutionExceptionHandler[] parseTransitionExecutingExceptionHandlers(List<TransitionModel> transitionModels) {
        if (transitionModels != null && !transitionModels.isEmpty()) {
            ArrayList<FlowExecutionExceptionHandler> exceptionHandlers = new ArrayList<FlowExecutionExceptionHandler>(transitionModels.size());
            for (TransitionModel model : transitionModels) {
                if (!StringUtils.hasText((String)model.getOnException())) continue;
                if (model.getSecured() != null) {
                    throw new FlowBuilderException("Exception based transitions cannot be secured");
                }
                exceptionHandlers.add(this.parseTransitionExecutingExceptionHandler(model));
            }
            return exceptionHandlers.toArray(new FlowExecutionExceptionHandler[exceptionHandlers.size()]);
        }
        return new FlowExecutionExceptionHandler[0];
    }

    private FlowExecutionExceptionHandler parseTransitionExecutingExceptionHandler(TransitionModel transition) {
        TransitionExecutingFlowExecutionExceptionHandler handler = new TransitionExecutingFlowExecutionExceptionHandler();
        Class<Throwable> exceptionClass = this.toClass(transition.getOnException(), Throwable.class);
        TargetStateResolver targetStateResolver = (TargetStateResolver)this.fromStringTo(TargetStateResolver.class).execute((Object)transition.getTo());
        handler.add(exceptionClass, targetStateResolver);
        handler.getActionList().addAll(this.parseActions(transition.getActions()));
        return handler;
    }

    private FlowExecutionExceptionHandler[] parseCustomExceptionHandlers(List<ExceptionHandlerModel> exceptionHandlerModels) {
        if (exceptionHandlerModels != null && !exceptionHandlerModels.isEmpty()) {
            ArrayList<FlowExecutionExceptionHandler> exceptionHandlers = new ArrayList<FlowExecutionExceptionHandler>(exceptionHandlerModels.size());
            for (ExceptionHandlerModel exceptionHandlerModel : exceptionHandlerModels) {
                exceptionHandlers.add(this.parseCustomExceptionHandler(exceptionHandlerModel));
            }
            return exceptionHandlers.toArray(new FlowExecutionExceptionHandler[exceptionHandlers.size()]);
        }
        return new FlowExecutionExceptionHandler[0];
    }

    private FlowExecutionExceptionHandler parseCustomExceptionHandler(ExceptionHandlerModel exceptionHandler) {
        return (FlowExecutionExceptionHandler)this.getLocalContext().getApplicationContext().getBean(exceptionHandler.getBean(), FlowExecutionExceptionHandler.class);
    }

    private Transition[] parseTransitions(List<TransitionModel> transitionModels) {
        if (transitionModels != null && !transitionModels.isEmpty()) {
            ArrayList<Transition> transitions = new ArrayList<Transition>(transitionModels.size());
            if (transitionModels != null) {
                for (TransitionModel transition : transitionModels) {
                    if (StringUtils.hasText((String)transition.getOnException())) continue;
                    transitions.add(this.parseTransition(transition));
                }
            }
            return transitions.toArray(new Transition[transitions.size()]);
        }
        return new Transition[0];
    }

    private Transition parseTransition(TransitionModel transition) {
        TransitionCriteria matchingCriteria = (TransitionCriteria)this.fromStringTo(TransitionCriteria.class).execute((Object)transition.getOn());
        TargetStateResolver stateResolver = (TargetStateResolver)this.fromStringTo(TargetStateResolver.class).execute((Object)transition.getTo());
        TransitionCriteria executionCriteria = TransitionCriteriaChain.criteriaChainFor((Action[])this.parseActions(transition.getActions()));
        MutableAttributeMap<Object> attributes = this.parseMetaAttributes(transition.getAttributes());
        if (StringUtils.hasText((String)transition.getBind())) {
            attributes.put("bind", this.fromStringTo(Boolean.class).execute((Object)transition.getBind()));
        }
        if (StringUtils.hasText((String)transition.getValidate())) {
            attributes.put("validate", this.fromStringTo(Boolean.class).execute((Object)transition.getValidate()));
        }
        if (StringUtils.hasText((String)transition.getValidationHints())) {
            attributes.put("validationHints", (Object)this.getLocalContext().getExpressionParser().parseExpression(transition.getValidationHints(), (ParserContext)new FluentParserContext().evaluate(RequestContext.class)));
        }
        if (StringUtils.hasText((String)transition.getHistory())) {
            attributes.put("history", this.fromStringTo(History.class).execute((Object)transition.getHistory().toUpperCase()));
        }
        this.parseAndPutSecured(transition.getSecured(), attributes);
        return this.getLocalContext().getFlowArtifactFactory().createTransition(stateResolver, matchingCriteria, executionCriteria, attributes);
    }

    private Action[] parseActions(List<AbstractActionModel> actionModels) {
        if (actionModels != null && !actionModels.isEmpty()) {
            ArrayList<AnnotatedAction> actions = new ArrayList<AnnotatedAction>(actionModels.size());
            for (AbstractActionModel actionModel : actionModels) {
                Object action = actionModel instanceof EvaluateModel ? this.parseEvaluateAction((EvaluateModel)actionModel) : (actionModel instanceof RenderModel ? this.parseRenderAction((RenderModel)actionModel) : (actionModel instanceof SetModel ? this.parseSetAction((SetModel)actionModel) : null));
                if (action == null) continue;
                AnnotatedAction annotatedAction = new AnnotatedAction(action);
                annotatedAction.getAttributes().putAll(this.parseMetaAttributes(actionModel.getAttributes()));
                actions.add(annotatedAction);
            }
            return actions.toArray(new Action[actions.size()]);
        }
        return new Action[0];
    }

    private Action parseEvaluateAction(EvaluateModel evaluate) {
        FluentParserContext evaluateExpressionParserContext = new FluentParserContext().evaluate(RequestContext.class);
        if (StringUtils.hasText((String)evaluate.getResultType())) {
            evaluateExpressionParserContext.expectResult(this.toClass(evaluate.getResultType()));
        }
        Expression evaluateExpression = this.getLocalContext().getExpressionParser().parseExpression(evaluate.getExpression(), (ParserContext)evaluateExpressionParserContext);
        Expression resultExpression = null;
        if (StringUtils.hasText((String)evaluate.getResult())) {
            resultExpression = this.getLocalContext().getExpressionParser().parseExpression(evaluate.getResult(), (ParserContext)new FluentParserContext().evaluate(RequestContext.class));
        }
        return new EvaluateAction(evaluateExpression, resultExpression);
    }

    private Action parseRenderAction(RenderModel render) {
        String[] fragmentExpressionStrings = StringUtils.commaDelimitedListToStringArray((String)render.getFragments());
        fragmentExpressionStrings = StringUtils.trimArrayElements((String[])fragmentExpressionStrings);
        FluentParserContext context = new FluentParserContext().template().evaluate(RequestContext.class).expectResult(String.class);
        Expression[] fragments = new Expression[fragmentExpressionStrings.length];
        for (int i = 0; i < fragmentExpressionStrings.length; ++i) {
            String fragment = fragmentExpressionStrings[i];
            fragments[i] = this.getLocalContext().getExpressionParser().parseExpression(fragment, (ParserContext)context);
        }
        return new RenderAction(fragments);
    }

    private Action parseSetAction(SetModel set) {
        Expression nameExpression = this.getLocalContext().getExpressionParser().parseExpression(set.getName(), (ParserContext)new FluentParserContext().evaluate(RequestContext.class));
        FluentParserContext valueParserContext = new FluentParserContext().evaluate(RequestContext.class);
        if (StringUtils.hasText((String)set.getType())) {
            valueParserContext.expectResult(this.toClass(set.getType()));
        }
        Expression valueExpression = this.getLocalContext().getExpressionParser().parseExpression(set.getValue(), (ParserContext)valueParserContext);
        return new SetAction(nameExpression, valueExpression);
    }

    private MutableAttributeMap<Object> parseMetaAttributes(List<AttributeModel> attributeModels) {
        if (attributeModels != null && !attributeModels.isEmpty()) {
            LocalAttributeMap attributes = new LocalAttributeMap();
            for (AttributeModel attributeModel : attributeModels) {
                this.parseAndPutMetaAttribute(attributeModel, (MutableAttributeMap<Object>)attributes);
            }
            return attributes;
        }
        return new LocalAttributeMap();
    }

    private void parseAndPutMetaAttribute(AttributeModel attribute, MutableAttributeMap<Object> attributes) {
        String name = attribute.getName();
        String value = attribute.getValue();
        attributes.put(name, this.parseAttributeValueIfNecessary(attribute, value));
    }

    private Object parseAttributeValueIfNecessary(AttributeModel attribute, String stringValue) {
        if (StringUtils.hasText((String)attribute.getType())) {
            Class<?> targetClass = this.toClass(attribute.getType());
            return this.fromStringTo(targetClass).execute((Object)stringValue);
        }
        return stringValue;
    }

    private void parseAndPutPersistenceContext(PersistenceContextModel persistenceContext, MutableAttributeMap<Object> attributes) {
        if (persistenceContext != null) {
            attributes.put("persistenceContext", (Object)true);
        }
    }

    private void parseAndPutSecured(SecuredModel secured, MutableAttributeMap<Object> attributes) {
        if (secured != null) {
            SecurityRule rule = new SecurityRule();
            rule.setAttributes(SecurityRule.commaDelimitedListToSecurityAttributes((String)secured.getAttributes()));
            String comparisonType = secured.getMatch();
            if ("any".equals(comparisonType)) {
                rule.setComparisonType((short)1);
            } else if ("all".equals(comparisonType)) {
                rule.setComparisonType((short)2);
            } else {
                rule.setComparisonType((short)1);
            }
            attributes.put("secured", (Object)rule);
        }
    }

    private ConversionExecutor fromStringTo(Class<?> targetType) throws ConversionExecutionException {
        return this.getLocalContext().getConversionService().getConversionExecutor(String.class, targetType);
    }

    private Class<?> toClass(String name) {
        Class clazz = this.getLocalContext().getConversionService().getClassForAlias(name);
        if (clazz != null) {
            return clazz;
        }
        try {
            ClassLoader classLoader = this.getLocalContext().getApplicationContext().getClassLoader();
            return ClassUtils.forName((String)name, (ClassLoader)classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unable to load class '" + name + "'");
        }
    }

    private <T> Class<T> toClass(String name, Class<T> superType) {
        Class<?> clazz = this.toClass(name);
        Assert.isAssignable(superType, clazz);
        return clazz;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("flowModelResource", (Object)this.flowModelHolder.getFlowModelResource()).toString();
    }
}

