/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.metadata;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.shibboleth.ext.spring.service.AbstractServiceableComponent;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataProviderContainer
extends AbstractServiceableComponent<MetadataResolver>
implements Comparable<MetadataProviderContainer> {
    private static int sortKeyValue;
    private final Logger log = LoggerFactory.getLogger(MetadataProviderContainer.class);
    @NonnullAfterInit
    private MetadataResolver resolver;
    @NonnullAfterInit
    private Integer sortKey;

    public void setSortKey(int key) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sortKey = key;
    }

    @Nonnull
    public void setEmbeddedResolver(@Nonnull MetadataResolver theResolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.resolver = (MetadataResolver)Constraint.isNotNull((Object)theResolver, (String)"MetadataResolver cannot be null");
    }

    @Nonnull
    public MetadataResolver getEmbeddedResolver() {
        return this.resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doInitialize() throws ComponentInitializationException {
        this.setId(this.resolver.getId());
        super.doInitialize();
        if (null == this.resolver) {
            throw new ComponentInitializationException("MetadataResolver cannot be null");
        }
        if (null != this.sortKey) return;
        Class<MetadataProviderContainer> clazz = MetadataProviderContainer.class;
        synchronized (MetadataProviderContainer.class) {
            this.sortKey = ++sortKeyValue;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.log.info("Top level Metadata Provider '{}' did not have a sort key; giving it value '{}'", (Object)this.getId(), (Object)this.sortKey);
            return;
        }
    }

    @Override
    public int compareTo(MetadataProviderContainer other) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        int result = this.sortKey.compareTo(other.sortKey);
        if (result != 0) {
            return result;
        }
        if (this.equals(other)) {
            return 0;
        }
        return this.getId().compareTo(other.getId());
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (!(other instanceof MetadataProviderContainer)) {
            return false;
        }
        MetadataProviderContainer otherRp = (MetadataProviderContainer)other;
        return Objects.equals(otherRp.sortKey, this.sortKey) && Objects.equals(this.getId(), otherRp.getId());
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.sortKey, this.getId()});
    }

    public MetadataResolver getComponent() {
        return this.getEmbeddedResolver();
    }
}

