/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.metadata;

import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.httpclient.HttpClientSupport;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.impl.SecurityEnhancedHttpClientSupport;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.x509.X509Credential;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class TLSSocketFactoryFactoryBean
extends AbstractFactoryBean<LayeredConnectionSocketFactory> {
    private TrustEngine<?> tlsTrustEngine;
    private HttpClientSecurityParameters httpClientSecurityParameters;
    private boolean connectionDisregardTLSCertificate;

    @Deprecated
    public void setTLSTrustEngine(@Nullable TrustEngine<? super X509Credential> engine) {
        this.tlsTrustEngine = engine;
    }

    public void setHttpClientSecurityParameters(@Nullable HttpClientSecurityParameters params) {
        this.httpClientSecurityParameters = params;
    }

    public void setConnectionDisregardTLSCertificate(boolean disregard) {
        this.connectionDisregardTLSCertificate = disregard;
    }

    public Class<LayeredConnectionSocketFactory> getObjectType() {
        return LayeredConnectionSocketFactory.class;
    }

    protected LayeredConnectionSocketFactory createInstance() throws Exception {
        boolean haveClientTLSCred;
        boolean haveTrustEngine = this.tlsTrustEngine != null || this.httpClientSecurityParameters != null && this.httpClientSecurityParameters.getTLSTrustEngine() != null;
        boolean bl = haveClientTLSCred = this.httpClientSecurityParameters != null && this.httpClientSecurityParameters.getClientTLSCredential() != null;
        if (haveTrustEngine || haveClientTLSCred) {
            return SecurityEnhancedHttpClientSupport.buildTLSSocketFactory((boolean)haveTrustEngine, (boolean)haveClientTLSCred);
        }
        if (this.connectionDisregardTLSCertificate) {
            return HttpClientSupport.buildNoTrustTLSSocketFactory();
        }
        return HttpClientSupport.buildStrictTLSSocketFactory();
    }
}

