/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.metadata.filter.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.util.AbstractCustomBeanDefinitionParser;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.idp.profile.spring.factory.BasicInlineCredentialFactoryBean;
import net.shibboleth.idp.profile.spring.factory.BasicX509CredentialFactoryBean;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.AbstractMetadataProviderParser;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.opensaml.saml.metadata.resolver.filter.impl.SignatureValidationFilter;
import org.opensaml.security.credential.impl.StaticCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.BasicProviderKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.provider.DSAKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.ECKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.InlineX509DataProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.RSAKeyValueProvider;
import org.opensaml.xmlsec.signature.support.impl.ExplicitKeySignatureTrustEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SignatureValidationParser
extends AbstractCustomBeanDefinitionParser {
    @Nonnull
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:metadata", "SignatureValidation");
    @Nonnull
    public static final QName PUBLIC_KEY = new QName("urn:mace:shibboleth:2.0:metadata", "PublicKey");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SignatureValidationParser.class);

    protected Class<?> getBeanClass(Element element) {
        return SignatureValidationFilter.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        boolean hasEngineRef = element.hasAttributeNS(null, "trustEngineRef");
        boolean hasCertFile = element.hasAttributeNS(null, "certificateFile");
        List publicKeys = ElementSupport.getChildElements((Node)element, (QName)PUBLIC_KEY);
        List trustEngines = ElementSupport.getChildElements((Node)element, (QName)AbstractMetadataProviderParser.TRUST_ENGINE_ELEMENT_NAME);
        super.doParse(element, parserContext, builder);
        if (hasEngineRef) {
            if (hasCertFile) {
                this.log.error("{}: trustEngineRef and certificateFile are mutually exclusive", (Object)parserContext.getReaderContext().getResource().getDescription());
                throw new BeanCreationException("trustEngineRef and certificateFile are mutually exclusive");
            }
            if (trustEngines != null && !trustEngines.isEmpty()) {
                this.log.error("{}: trustEngineRef and Embedded <TrustEngine> are mutually exclusive", (Object)parserContext.getReaderContext().getResource().getDescription());
                throw new BeanCreationException("trustEngineRef and Embedded <TrustEngine> are mutually exclusive");
            }
            if (null != publicKeys && !publicKeys.isEmpty()) {
                this.log.error("{}: trustEngineRef and certificateFile are mutually exclusive", (Object)parserContext.getReaderContext().getResource().getDescription());
                throw new BeanCreationException("trustEngineRef and embedded public keys are mutually exclusive");
            }
            builder.addConstructorArgReference(StringSupport.trimOrNull((String)element.getAttributeNS(null, "trustEngineRef")));
        } else if (hasCertFile) {
            if (null != publicKeys && !publicKeys.isEmpty()) {
                this.log.error("{}: certificateFile and embedded public keys are mutually exclusive", (Object)parserContext.getReaderContext().getResource().getDescription());
                throw new BeanCreationException("certificateFile and embedded public keys are mutually exclusive");
            }
            if (trustEngines != null && !trustEngines.isEmpty()) {
                this.log.error("{}: certificateFile and Embedded <TrustEngine> are mutually exclusive", (Object)parserContext.getReaderContext().getResource().getDescription());
                throw new BeanCreationException("Embedded <TrustEngine> and certificateFile are mutually exclusive");
            }
            this.buildTrustEngine(builder, this.buildCertificateCredential(element.getAttributeNS(null, "certificateFile")));
        } else if (null != trustEngines && !trustEngines.isEmpty()) {
            if (trustEngines.size() > 1) {
                this.log.error("{}: Too many <TrustEngine>s", (Object)parserContext.getReaderContext().getResource().getDescription());
                throw new BeanCreationException("Too many <TrustEngine>s");
            }
            ManagedList engines = SpringSupport.parseCustomElements((Collection)trustEngines, (ParserContext)parserContext, (BeanDefinitionBuilder)builder);
            builder.addConstructorArgValue(engines.get(0));
        } else {
            this.buildTrustEngine(builder, this.buildPublicKeyCredential(parserContext, publicKeys));
        }
        if (element.hasAttributeNS(null, "requireSignedRoot")) {
            builder.addPropertyValue("requireSignedRoot", (Object)SpringSupport.getStringValueAsBoolean((String)element.getAttributeNS(null, "requireSignedRoot")));
        }
        if (element.hasAttributeNS(null, "alwaysVerifyTrustedSource")) {
            builder.addPropertyValue("alwaysVerifyTrustedSource", (Object)SpringSupport.getStringValueAsBoolean((String)element.getAttributeNS(null, "alwaysVerifyTrustedSource")));
        }
        if (element.hasAttributeNS(null, "defaultCriteriaRef")) {
            builder.addPropertyReference("defaultCriteria", element.getAttributeNS(null, "defaultCriteriaRef"));
        } else {
            builder.addPropertyReference("defaultCriteria", "shibboleth.MetadataSignatureValidationStaticCriteria");
        }
        if (element.hasAttributeNS(null, "signaturePrevalidatorRef")) {
            builder.addPropertyReference("signaturePrevalidator", element.getAttributeNS(null, "signaturePrevalidatorRef"));
        }
        if (element.hasAttributeNS(null, "dynamicTrustedNamesStrategyRef")) {
            builder.addPropertyReference("dynamicTrustedNamesStrategy", element.getAttributeNS(null, "dynamicTrustedNamesStrategyRef"));
        }
    }

    private void buildTrustEngine(BeanDefinitionBuilder builder, BeanDefinition credential) {
        BeanDefinitionBuilder trustEngineBuilder = BeanDefinitionBuilder.genericBeanDefinition(ExplicitKeySignatureTrustEngine.class);
        BeanDefinitionBuilder resolver = BeanDefinitionBuilder.genericBeanDefinition(StaticCredentialResolver.class);
        resolver.addConstructorArgValue((Object)credential);
        trustEngineBuilder.addConstructorArgValue((Object)resolver.getBeanDefinition());
        ArrayList<Object> keyInfoProviders = new ArrayList<Object>();
        keyInfoProviders.add(new DSAKeyValueProvider());
        keyInfoProviders.add(new RSAKeyValueProvider());
        keyInfoProviders.add(new ECKeyValueProvider());
        keyInfoProviders.add(new InlineX509DataProvider());
        trustEngineBuilder.addConstructorArgValue((Object)new BasicProviderKeyInfoCredentialResolver(keyInfoProviders));
        builder.addConstructorArgValue((Object)trustEngineBuilder.getBeanDefinition());
    }

    private BeanDefinition buildPublicKeyCredential(ParserContext parserContext, List<Element> publicKeys) {
        if (null == publicKeys || publicKeys.isEmpty()) {
            this.log.error("{}: SignatureValidation filter must have a 'trustEngineRef' attribute, a 'certificateFile' attribute or <PublicKey> elements", (Object)parserContext.getReaderContext().getResource().getDescription());
            throw new BeanCreationException("SignatureValidation filter must have a 'trustEngineRef' attribute, a 'certificateFile' attribute or <PublicKey> elements");
        }
        if (publicKeys.size() > 1) {
            this.log.error("{}: Only one <PublicKey> element may be specified", (Object)parserContext.getReaderContext().getResource().getDescription());
            throw new BeanCreationException("Only one <PublicKey> element may be specified");
        }
        BeanDefinitionBuilder credentialBuilder = BeanDefinitionBuilder.genericBeanDefinition(BasicInlineCredentialFactoryBean.class);
        String keyAsString = StringSupport.trimOrNull((String)publicKeys.get(0).getTextContent());
        if (null == keyAsString) {
            this.log.error("{}: <PublicKey> must contain the public key", (Object)parserContext.getReaderContext().getResource().getDescription());
            throw new BeanCreationException("<PublicKey> must contain the public key");
        }
        ManagedList keys = new ManagedList(1);
        keys.add(keyAsString);
        credentialBuilder.addPropertyValue("publicKeyInfo", (Object)keyAsString);
        return credentialBuilder.getBeanDefinition();
    }

    private BeanDefinition buildCertificateCredential(String attribute) {
        BeanDefinitionBuilder credentialBuilder = BeanDefinitionBuilder.genericBeanDefinition(BasicX509CredentialFactoryBean.class);
        ManagedList certs = new ManagedList(1);
        certs.add(attribute);
        credentialBuilder.addPropertyValue("certificates", (Object)certs);
        return credentialBuilder.getBeanDefinition();
    }

    protected boolean shouldGenerateId() {
        return true;
    }
}

