/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.metadata.impl;

import java.util.List;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.InMemoryCachingHttpClientFactoryBean;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.impl.AbstractDynamicMetadataProviderParser;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.impl.HTTPMetadataProvidersParserSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractDynamicHTTPMetadataProviderParser
extends AbstractDynamicMetadataProviderParser {
    private static final Class<?> DEFAULT_CACHING_CLASS = InMemoryCachingHttpClientFactoryBean.class;
    private static final Integer DEFAULT_MAX_CONNECTIONS_TOTAL = 100;
    private static final Integer DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 100;
    private static final String DEFAULT_CONNECTION_REQUEST_TIMEOUT = "PT5S";
    private static final String DEFAULT_CONNECTION_TIMEOUT = "PT5S";
    private static final String DEFAULT_SOCKET_TIMEOUT = "PT5S";
    private final Logger log = LoggerFactory.getLogger(AbstractDynamicHTTPMetadataProviderParser.class);

    @Override
    protected void doNativeParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doNativeParse(element, parserContext, builder);
        Element tlsTrustEngine = ElementSupport.getFirstChildElement((Node)element, (QName)HTTPMetadataProvidersParserSupport.TLS_TRUST_ENGINE_ELEMENT_NAME);
        String httpClientSecurityParametersRef = StringSupport.trimOrNull((String)element.getAttributeNS(null, "httpClientSecurityParametersRef"));
        BeanDefinition httpClientSecurityParameters = null;
        if (httpClientSecurityParametersRef != null) {
            if (tlsTrustEngine != null) {
                this.log.warn("httpClientSecurityParametersRef overrides <TrustEngine> subelement");
            }
            builder.addPropertyReference("httpClientSecurityParameters", httpClientSecurityParametersRef);
        } else if (tlsTrustEngine != null) {
            httpClientSecurityParameters = HTTPMetadataProvidersParserSupport.parseTLSTrustEngine(tlsTrustEngine, parserContext);
            builder.addPropertyValue("httpClientSecurityParameters", (Object)httpClientSecurityParameters);
        }
        if (element.hasAttributeNS(null, "httpClientRef")) {
            builder.addConstructorArgReference(StringSupport.trimOrNull((String)element.getAttributeNS(null, "httpClientRef")));
            if (element.hasAttributeNS(null, "connectionTimeout") || element.hasAttributeNS(null, "connectionRequestTimeout") || element.hasAttributeNS(null, "socketTimeout") || element.hasAttributeNS(null, "maxConnectionsTotal") || element.hasAttributeNS(null, "maxConnectionsPerRoute") || element.hasAttributeNS(null, "disregardTLSCertificate") || element.hasAttributeNS(null, "proxyHost") || element.hasAttributeNS(null, "proxyPort") || element.hasAttributeNS(null, "proxyUser") || element.hasAttributeNS(null, "proxyPassword")) {
                this.log.warn("httpClientRef overrides settings for connectionTimeout, connectionRequestTimeout, socketTimeout, maxConnectionsTotal, maxConnectionsPerRoute, disregardTLSCertificate, proxyHost, proxyPort, proxyUser and proxyPassword");
            }
        } else {
            builder.addConstructorArgValue((Object)this.buildHttpClient(element, parserContext, httpClientSecurityParametersRef, httpClientSecurityParameters));
        }
        if (element.hasAttributeNS(null, "supportedContentTypes")) {
            List supportedContentTypes = StringSupport.stringToList((String)StringSupport.trimOrNull((String)element.getAttributeNS(null, "supportedContentTypes")), (String)" \n\r\t");
            builder.addPropertyValue("supportedContentTypes", (Object)supportedContentTypes);
        }
    }

    private BeanDefinition buildHttpClient(Element element, ParserContext parserContext, @Nullable String httpClientSecurityParametersRef, @Nullable BeanDefinition httpClientSecurityParameters) {
        BeanDefinitionBuilder clientBuilder = HTTPMetadataProvidersParserSupport.buildCommonClientBuilder(element, parserContext, DEFAULT_CACHING_CLASS, httpClientSecurityParametersRef, httpClientSecurityParameters);
        if (!element.hasAttributeNS(null, "connectionTimeout")) {
            clientBuilder.addPropertyValue("connectionTimeout", (Object)"PT5S");
        }
        if (!element.hasAttributeNS(null, "connectionRequestTimeout")) {
            clientBuilder.addPropertyValue("connectionRequestTimeout", (Object)"PT5S");
        }
        if (!element.hasAttributeNS(null, "socketTimeout")) {
            clientBuilder.addPropertyValue("socketTimeout", (Object)"PT5S");
        }
        if (element.hasAttributeNS(null, "maxConnectionsTotal")) {
            clientBuilder.addPropertyValue("maxConnectionsTotal", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "maxConnectionsTotal")));
        } else {
            clientBuilder.addPropertyValue("maxConnectionsTotal", (Object)DEFAULT_MAX_CONNECTIONS_TOTAL);
        }
        if (element.hasAttributeNS(null, "maxConnectionsPerRoute")) {
            clientBuilder.addPropertyValue("maxConnectionsPerRoute", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "maxConnectionsPerRoute")));
        } else {
            clientBuilder.addPropertyValue("maxConnectionsPerRoute", (Object)DEFAULT_MAX_CONNECTIONS_PER_ROUTE);
        }
        return clientBuilder.getBeanDefinition();
    }
}

