/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.metadata.impl;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.metadata.impl.ByReferenceMetadataFilterBridge;
import org.opensaml.saml.metadata.resolver.ChainingMetadataResolver;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterChain;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;

public class ByReferenceFilterBeanPostProcessor
implements BeanPostProcessor,
ApplicationContextAware,
Ordered {
    private boolean enabled = true;
    @Nullable
    private ApplicationContext applicationContext;

    public void setEnabled(boolean flag) {
        this.enabled = flag;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void setApplicationContext(@Nullable ApplicationContext context) throws BeansException {
        this.applicationContext = context;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        if (!this.enabled || !(bean instanceof MetadataResolver) || bean instanceof ChainingMetadataResolver) {
            return bean;
        }
        MetadataResolver resolver = (MetadataResolver)bean;
        boolean filterAttached = false;
        MetadataFilter filter = resolver.getMetadataFilter();
        if (filter instanceof ByReferenceMetadataFilterBridge) {
            filterAttached = true;
        } else if (filter instanceof MetadataFilterChain) {
            filterAttached = ((MetadataFilterChain)filter).getFilters().stream().anyMatch(f -> f instanceof ByReferenceMetadataFilterBridge);
        }
        if (!filterAttached) {
            ByReferenceMetadataFilterBridge filterToAttach = new ByReferenceMetadataFilterBridge();
            filterToAttach.setApplicationContext(this.applicationContext);
            if (filter == null) {
                resolver.setMetadataFilter((MetadataFilter)filterToAttach);
            } else if (filter instanceof MetadataFilterChain) {
                ((MetadataFilterChain)filter).getFilters().add(filterToAttach);
            } else {
                MetadataFilterChain chain = new MetadataFilterChain();
                chain.setFilters(Arrays.asList(filter, filterToAttach));
                resolver.setMetadataFilter((MetadataFilter)chain);
            }
        }
        return resolver;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        return bean;
    }
}

