/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.metadata.impl;

import javax.xml.namespace.QName;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.impl.AbstractDynamicHTTPMetadataProviderParser;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.FunctionDrivenDynamicHTTPMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.HTTPEntityIDRequestURLBuilder;
import org.opensaml.saml.metadata.resolver.impl.MetadataQueryProtocolRequestURLBuilder;
import org.opensaml.saml.metadata.resolver.impl.RegexRequestURLBuilder;
import org.opensaml.saml.metadata.resolver.impl.TemplateRequestURLBuilder;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DynamicHTTPMetadataProviderParser
extends AbstractDynamicHTTPMetadataProviderParser {
    public static final QName ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:metadata", "DynamicHTTPMetadataProvider");
    private static final QName TEMPLATE = new QName("urn:mace:shibboleth:2.0:metadata", "Template");
    private static final QName REGEX = new QName("urn:mace:shibboleth:2.0:metadata", "Regex");
    private static final QName METADATA_QUERY_PROTOCOL = new QName("urn:mace:shibboleth:2.0:metadata", "MetadataQueryProtocol");
    private static final String DEFAULT_VELOCITY_ENGINE_REF = "shibboleth.VelocityEngine";

    @Override
    protected Class<? extends MetadataResolver> getNativeBeanClass(Element element) {
        return FunctionDrivenDynamicHTTPMetadataResolver.class;
    }

    @Override
    protected void doNativeParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doNativeParse(element, parserContext, builder);
        builder.addPropertyValue("requestURLBuilder", (Object)this.getRequestURLBuilder(element, builder));
    }

    protected BeanDefinition getRequestURLBuilder(Element element, BeanDefinitionBuilder parentBuilder) {
        Element template = ElementSupport.getFirstChildElement((Node)element, (QName)TEMPLATE);
        if (template != null) {
            String templateString = StringSupport.trimOrNull((String)ElementSupport.getElementContentAsString((Element)template));
            String encodingStyle = this.parseTemplateEncodingStyle(template);
            String velocityEngineRef = StringSupport.trimOrNull((String)StringSupport.trimOrNull((String)template.getAttributeNS(null, "velocityEngine")));
            if (null == velocityEngineRef) {
                velocityEngineRef = DEFAULT_VELOCITY_ENGINE_REF;
            }
            String transformRef = StringSupport.trimOrNull((String)StringSupport.trimOrNull((String)template.getAttributeNS(null, "transformRef")));
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(TemplateRequestURLBuilder.class);
            builder.addConstructorArgReference(velocityEngineRef);
            builder.addConstructorArgValue((Object)templateString);
            builder.addConstructorArgValue((Object)encodingStyle);
            if (transformRef != null) {
                builder.addConstructorArgReference(transformRef);
            }
            return builder.getBeanDefinition();
        }
        Element regex = ElementSupport.getFirstChildElement((Node)element, (QName)REGEX);
        if (regex != null) {
            String replacement = StringSupport.trimOrNull((String)ElementSupport.getElementContentAsString((Element)regex));
            String match = StringSupport.trimOrNull((String)StringSupport.trimOrNull((String)regex.getAttributeNS(null, "match")));
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(RegexRequestURLBuilder.class);
            builder.addConstructorArgValue((Object)match);
            builder.addConstructorArgValue((Object)replacement);
            return builder.getBeanDefinition();
        }
        Element mdq = ElementSupport.getFirstChildElement((Node)element, (QName)METADATA_QUERY_PROTOCOL);
        if (mdq != null) {
            String baseURL = ElementSupport.getElementContentAsString((Element)mdq);
            String transformRef = StringSupport.trimOrNull((String)StringSupport.trimOrNull((String)mdq.getAttributeNS(null, "transformRef")));
            String secondaryURLBuildersRef = StringSupport.trimOrNull((String)StringSupport.trimOrNull((String)mdq.getAttributeNS(null, "secondaryURLBuildersRef")));
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(MetadataQueryProtocolRequestURLBuilder.class);
            builder.addConstructorArgValue((Object)baseURL);
            if (transformRef != null) {
                builder.addConstructorArgReference(transformRef);
            }
            if (secondaryURLBuildersRef != null) {
                builder.addConstructorArgReference(secondaryURLBuildersRef);
            }
            if (!element.hasAttributeNS(null, "supportedContentTypes")) {
                parentBuilder.addPropertyValue("supportedContentTypes", (Object)"application/samlmetadata+xml");
            }
            return builder.getBeanDefinition();
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(HTTPEntityIDRequestURLBuilder.class);
        return builder.getBeanDefinition();
    }

    private String parseTemplateEncodingStyle(Element template) {
        String encodingStyle = null;
        if (template.hasAttributeNS(null, "encodingStyle")) {
            encodingStyle = StringSupport.trimOrNull((String)template.getAttributeNS(null, "encodingStyle"));
        }
        if (encodingStyle == null) {
            encodingStyle = "form";
        }
        return encodingStyle;
    }
}

