/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.metadata.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.HttpClientFactoryBean;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.impl.AbstractReloadingMetadataProviderParser;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.impl.HTTPMetadataProvidersParserSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class HTTPMetadataProviderParser
extends AbstractReloadingMetadataProviderParser {
    private static final Class<?> DEFAULT_CACHING_CLASS = HttpClientFactoryBean.class;
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTTPMetadataProviderParser.class);

    @Override
    protected void doNativeParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doNativeParse(element, parserContext, builder);
        Element tlsTrustEngine = ElementSupport.getFirstChildElement((Node)element, (QName)HTTPMetadataProvidersParserSupport.TLS_TRUST_ENGINE_ELEMENT_NAME);
        String httpClientSecurityParametersRef = StringSupport.trimOrNull((String)element.getAttributeNS(null, "httpClientSecurityParametersRef"));
        BeanDefinition httpClientSecurityParameters = null;
        if (httpClientSecurityParametersRef != null) {
            if (tlsTrustEngine != null) {
                this.log.warn("httpClientSecurityParametersRef overrides <TrustEngine> subelement");
            }
            builder.addPropertyReference("httpClientSecurityParameters", httpClientSecurityParametersRef);
        } else if (tlsTrustEngine != null) {
            httpClientSecurityParameters = HTTPMetadataProvidersParserSupport.parseTLSTrustEngine(tlsTrustEngine, parserContext);
            builder.addPropertyValue("httpClientSecurityParameters", (Object)httpClientSecurityParameters);
        }
        if (element.hasAttributeNS(null, "httpClientRef")) {
            builder.addConstructorArgReference(StringSupport.trimOrNull((String)element.getAttributeNS(null, "httpClientRef")));
            if (element.hasAttributeNS(null, "connectionTimeout") || element.hasAttributeNS(null, "connectionRequestTimeout") || element.hasAttributeNS(null, "socketTimeout") || element.hasAttributeNS(null, "disregardTLSCertificate") || element.hasAttributeNS(null, "proxyHost") || element.hasAttributeNS(null, "proxyPort") || element.hasAttributeNS(null, "proxyUser") || element.hasAttributeNS(null, "proxyPassword")) {
                this.log.warn("httpClientRef overrides settings for connectionTimeout, connectionRequestTimeout, socketTimeout, disregardTLSCertificate,  proxyHost, proxyPort, proxyUser and proxyPassword");
            }
        } else {
            builder.addConstructorArgValue((Object)this.buildHttpClient(element, parserContext, httpClientSecurityParametersRef, httpClientSecurityParameters));
        }
        builder.addConstructorArgValue((Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "metadataURL")));
    }

    private BeanDefinition buildHttpClient(Element element, ParserContext parserContext, @Nullable String httpClientSecurityParametersRef, @Nullable BeanDefinition httpClientSecurityParameters) {
        return HTTPMetadataProvidersParserSupport.buildCommonClientBuilder(element, parserContext, DEFAULT_CACHING_CLASS, httpClientSecurityParametersRef, httpClientSecurityParameters).getBeanDefinition();
    }
}

