/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.metadata.impl;

import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.resource.ResourceHelper;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.impl.AbstractReloadingMetadataProviderParser;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import org.opensaml.saml.metadata.resolver.impl.AbstractBatchMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.ResourceBackedMetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class ResourceBackedMetadataProviderParser
extends AbstractReloadingMetadataProviderParser {
    @Nonnull
    public static final QName ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:metadata", "ResourceBackedMetadataProvider");
    @Nonnull
    public static final QName RESOURCES_NAME = new QName("urn:mace:shibboleth:2.0:metadata", "MetadataResource");
    @Nonnull
    public static final QName RESOURCE_REF = new QName("resourceRef");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ResourceBackedMetadataProviderParser.class);

    protected Class<? extends AbstractBatchMetadataResolver> getNativeBeanClass(Element element) {
        if (AttributeSupport.hasAttribute((Element)element, (QName)RESOURCE_REF)) {
            return ResourceBackedMetadataResolver.class;
        }
        throw new BeanCreationException("No resourceRef specified for ResourceBackedMetadataProvider");
    }

    @Override
    protected void doNativeParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doNativeParse(element, parserContext, builder);
        String beanRef = StringSupport.trimOrNull((String)AttributeSupport.getAttributeValue((Element)element, (QName)RESOURCE_REF));
        if (null == beanRef) {
            this.log.error("{} must not be empty", (Object)RESOURCE_REF.getLocalPart());
            throw new BeanDefinitionParsingException(new Problem("Empty bean reference for a ResourceBackedMetadataProvider", new Location(parserContext.getReaderContext().getResource())));
        }
        BeanDefinitionBuilder resourceConverter = BeanDefinitionBuilder.genericBeanDefinition(ResourceHelper.class);
        resourceConverter.setLazyInit(true);
        resourceConverter.setFactoryMethod("of");
        resourceConverter.addConstructorArgReference(beanRef);
        builder.addConstructorArgValue((Object)resourceConverter.getBeanDefinition());
    }
}

