/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.metadata.impl;

import com.google.common.base.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.ext.spring.service.AbstractServiceableComponent;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.RefreshableMetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelyingPartyMetadataProvider
extends AbstractServiceableComponent<MetadataResolver>
implements RefreshableMetadataResolver,
Comparable<RelyingPartyMetadataProvider> {
    private static int sortKeyValue;
    private final Logger log = LoggerFactory.getLogger(RelyingPartyMetadataProvider.class);
    @Nonnull
    private final MetadataResolver resolver;
    @NonnullAfterInit
    private Integer sortKey;

    public RelyingPartyMetadataProvider(@Nonnull MetadataResolver child) {
        this.resolver = (MetadataResolver)Constraint.isNotNull((Object)child, (String)"MetadataResolver cannot be null");
    }

    public void setSortKey(int key) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sortKey = new Integer(key);
    }

    @Nonnull
    public MetadataResolver getEmbeddedResolver() {
        return this.resolver;
    }

    @Nonnull
    public Iterable<EntityDescriptor> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        return this.resolver.resolve((Object)criteria);
    }

    @Nullable
    public EntityDescriptor resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        return (EntityDescriptor)this.resolver.resolveSingle((Object)criteria);
    }

    public boolean isRequireValidMetadata() {
        return this.resolver.isRequireValidMetadata();
    }

    public void setRequireValidMetadata(boolean requireValidMetadata) {
        this.resolver.setRequireValidMetadata(requireValidMetadata);
    }

    @Nullable
    public MetadataFilter getMetadataFilter() {
        return this.resolver.getMetadataFilter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInitialize() throws ComponentInitializationException {
        this.setId(this.resolver.getId());
        super.doInitialize();
        if (null == this.sortKey) {
            RelyingPartyMetadataProvider relyingPartyMetadataProvider = this;
            synchronized (relyingPartyMetadataProvider) {
                this.sortKey = new Integer(++sortKeyValue);
            }
            this.log.info("Top level Metadata Provider '{}' did not have a sort key giving it value {}");
        }
    }

    public void setMetadataFilter(@Nullable MetadataFilter newFilter) {
        this.resolver.setMetadataFilter(newFilter);
    }

    @Nonnull
    public MetadataResolver getComponent() {
        return this;
    }

    public void refresh() throws ResolverException {
        if (this.resolver instanceof RefreshableMetadataResolver) {
            ((RefreshableMetadataResolver)this.resolver).refresh();
        }
    }

    @Override
    public int compareTo(RelyingPartyMetadataProvider other) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        int result = this.sortKey.compareTo(other.sortKey);
        if (result != 0) {
            return result;
        }
        if (this.equals(other)) {
            return 0;
        }
        return this.getId().compareTo(other.getId());
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (!(other instanceof RelyingPartyMetadataProvider)) {
            return false;
        }
        RelyingPartyMetadataProvider otherRp = (RelyingPartyMetadataProvider)other;
        return Objects.equal((Object)otherRp.sortKey, (Object)this.sortKey) && Objects.equal((Object)this.getId(), (Object)otherRp.getId());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.sortKey, this.getId()});
    }
}

