/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.saml.metadata.impl.RelyingPartyMetadataProvider;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.metadata.resolver.ChainingMetadataResolver;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.RefreshableMetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadMetadata
extends AbstractProfileAction {
    @Nonnull
    @NotEmpty
    public static final String RESOLVER_ID = "id";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ReloadMetadata.class);
    @NonnullAfterInit
    private ReloadableService<MetadataResolver> metadataResolverService;
    @Nullable
    private String id;

    public void setMetadataResolver(@Nonnull ReloadableService<MetadataResolver> service) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.metadataResolverService = (ReloadableService)Constraint.isNotNull(service, (String)"MetadataResolver service cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.metadataResolverService == null) {
            throw new ComponentInitializationException("MetadataResolver service cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.getHttpServletResponse() == null) {
            this.log.debug("{} No HttpServletResponse available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        String string = this.id = this.getHttpServletRequest() != null ? this.getHttpServletRequest().getParameter(RESOLVER_ID) : null;
        if (this.id == null) {
            this.log.debug("{} No 'id' parameter found in request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.log.debug("{} Reloading metadata from '{}'", (Object)this.getLogPrefix(), (Object)this.id);
        ServiceableComponent component = this.metadataResolverService.getServiceableComponent();
        try {
            RefreshableMetadataResolver toRefresh = null;
            MetadataResolver rootResolver = (MetadataResolver)component.getComponent();
            if (rootResolver instanceof RelyingPartyMetadataProvider) {
                rootResolver = ((RelyingPartyMetadataProvider)rootResolver).getEmbeddedResolver();
            }
            if (Objects.equals(this.id, rootResolver.getId()) && rootResolver instanceof RefreshableMetadataResolver) {
                toRefresh = (RefreshableMetadataResolver)rootResolver;
            } else if (rootResolver instanceof ChainingMetadataResolver) {
                for (MetadataResolver childResolver : ((ChainingMetadataResolver)rootResolver).getResolvers()) {
                    if (!Objects.equals(this.id, childResolver.getId()) || !(childResolver instanceof RefreshableMetadataResolver)) continue;
                    toRefresh = (RefreshableMetadataResolver)childResolver;
                    break;
                }
            }
            if (toRefresh != null) {
                toRefresh.refresh();
                this.log.debug("{} Reloaded metadata from '{}'", (Object)this.getLogPrefix(), (Object)this.id);
                this.getHttpServletResponse().setStatus(200);
                this.getHttpServletResponse().getWriter().println("Metadata reloaded.");
            } else {
                this.log.debug("{} Unable to locate refreshable metadata source '{}'", (Object)this.getLogPrefix(), (Object)this.id);
                this.getHttpServletResponse().sendError(404, "Metadata source not found.");
            }
        }
        catch (ResolverException e) {
            this.log.error("{} MetadataProvider '{}': Error during refresh", new Object[]{this.getLogPrefix(), this.id, e});
            try {
                this.getHttpServletResponse().sendError(500, e.getMessage());
            }
            catch (IOException e2) {
                this.log.error("{} I/O error responding to request", (Object)this.getLogPrefix(), (Object)e2);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            }
        }
        catch (IOException e) {
            this.log.error("{} I/O error responding to request", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
        }
        finally {
            if (null != component) {
                component.unpinComponent();
            }
        }
    }
}

