/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributeEncoder;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.saml.attribute.encoding.SAML2AttributeEncoder;
import net.shibboleth.idp.saml.profile.impl.BaseAddAttributeStatementToAssertion;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.profile.SAML2ActionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddAttributeStatementToAssertion
extends BaseAddAttributeStatementToAssertion {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddAttributeStatementToAssertion.class);
    @Nonnull
    private Function<ProfileRequestContext, Assertion> assertionLookupStrategy = new AssertionStrategy();

    public void setAssertionLookupStrategy(@Nonnull Function<ProfileRequestContext, Assertion> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.assertionLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Assertion lookup strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        try {
            AttributeStatement statement = this.buildAttributeStatement(profileRequestContext, this.getAttributeContext().getIdPAttributes().values());
            if (statement == null) {
                this.log.debug("{} No AttributeStatement was built, nothing to do", (Object)this.getLogPrefix());
                return;
            }
            Assertion assertion = (Assertion)this.assertionLookupStrategy.apply((Object)profileRequestContext);
            if (assertion == null) {
                this.log.error("Unable to obtain Assertion to modify");
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
                return;
            }
            assertion.getAttributeStatements().add(statement);
            this.log.debug("{} Adding constructed AttributeStatement to Assertion {} ", (Object)this.getLogPrefix(), (Object)assertion.getID());
        }
        catch (AttributeEncodingException e) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToEncodeAttribute");
        }
    }

    @Nullable
    private AttributeStatement buildAttributeStatement(@Nonnull ProfileRequestContext profileRequestContext, @Nullable @NullableElements Collection<IdPAttribute> attributes) throws AttributeEncodingException {
        if (attributes == null || attributes.isEmpty()) {
            this.log.debug("{} No attributes available to be encoded, nothing to do", (Object)this.getLogPrefix());
            return null;
        }
        ArrayList<Attribute> encodedAttributes = new ArrayList<Attribute>(attributes.size());
        for (IdPAttribute attribute : Collections2.filter(attributes, (Predicate)Predicates.notNull())) {
            Attribute encodedAttribute = this.encodeAttribute(profileRequestContext, attribute);
            if (encodedAttribute == null) continue;
            encodedAttributes.add(encodedAttribute);
        }
        if (encodedAttributes.isEmpty()) {
            this.log.debug("{} No attributes were encoded as SAML 2 Attributes, nothing to do", (Object)this.getLogPrefix());
            return null;
        }
        SAMLObjectBuilder statementBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(AttributeStatement.DEFAULT_ELEMENT_NAME);
        AttributeStatement statement = (AttributeStatement)statementBuilder.buildObject();
        statement.getAttributes().addAll(encodedAttributes);
        return statement;
    }

    @Nullable
    private Attribute encodeAttribute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull IdPAttribute attribute) throws AttributeEncodingException {
        this.log.debug("{} Attempting to encode attribute {} as a SAML 2 Attribute", (Object)this.getLogPrefix(), (Object)attribute.getId());
        Set encoders = attribute.getEncoders();
        if (encoders.isEmpty()) {
            this.log.debug("{} Attribute {} does not have any encoders, nothing to do", (Object)this.getLogPrefix(), (Object)attribute.getId());
            return null;
        }
        for (AttributeEncoder encoder : encoders) {
            if (!"urn:oasis:names:tc:SAML:2.0:protocol".equals(encoder.getProtocol()) || !(encoder instanceof SAML2AttributeEncoder) || !encoder.getActivationCondition().apply((Object)profileRequestContext)) continue;
            this.log.debug("{} Encoding attribute {} as a SAML 2 Attribute", (Object)this.getLogPrefix(), (Object)attribute.getId());
            try {
                return (Attribute)encoder.encode(attribute);
            }
            catch (AttributeEncodingException e) {
                if (this.isIgnoringUnencodableAttributes()) {
                    this.log.debug("{} Unable to encode attribute {} as SAML 2 attribute", new Object[]{this.getLogPrefix(), attribute.getId(), e});
                    continue;
                }
                throw e;
            }
        }
        this.log.debug("{} Attribute {} did not have a usable SAML 2 Attribute encoder associated with it, nothing to do", (Object)this.getLogPrefix(), (Object)attribute.getId());
        return null;
    }

    private class AssertionStrategy
    implements Function<ProfileRequestContext, Assertion> {
        private AssertionStrategy() {
        }

        @Nullable
        public Assertion apply(@Nullable ProfileRequestContext input) {
            if (input != null && input.getOutboundMessageContext() != null) {
                Object outboundMessage = input.getOutboundMessageContext().getMessage();
                if (outboundMessage == null) {
                    Assertion ret = SAML2ActionSupport.buildAssertion((AbstractProfileAction)AddAttributeStatementToAssertion.this, (IdentifierGenerationStrategy)AddAttributeStatementToAssertion.this.getIdGenerator(), (String)AddAttributeStatementToAssertion.this.getIssuerId());
                    input.getOutboundMessageContext().setMessage((Object)ret);
                    return ret;
                }
                if (outboundMessage instanceof Assertion) {
                    return (Assertion)outboundMessage;
                }
                if (outboundMessage instanceof Response) {
                    if (AddAttributeStatementToAssertion.this.isStatementInOwnAssertion() || ((Response)outboundMessage).getAssertions().isEmpty()) {
                        return SAML2ActionSupport.addAssertionToResponse((AbstractProfileAction)AddAttributeStatementToAssertion.this, (Response)((Response)outboundMessage), (IdentifierGenerationStrategy)AddAttributeStatementToAssertion.this.getIdGenerator(), (String)AddAttributeStatementToAssertion.this.getIssuerId());
                    }
                    return (Assertion)((Response)outboundMessage).getAssertions().get(0);
                }
            }
            return null;
        }
    }
}

