/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.delegation.impl;

import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.saml.saml2.profile.delegation.LibertySSOSContext;
import net.shibboleth.utilities.java.support.annotation.Prototype;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.wssecurity.SAML20AssertionToken;
import org.opensaml.soap.wssecurity.messaging.Token;
import org.opensaml.soap.wssecurity.messaging.WSSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Prototype
public class PopulateLibertyContext
extends AbstractProfileAction {
    private Logger log = LoggerFactory.getLogger(PopulateLibertyContext.class);
    @Nonnull
    private Function<ProfileRequestContext, SAML20AssertionToken> assertionTokenStrategy = new TokenStrategy();
    @Nonnull
    private Function<ProfileRequestContext, LibertySSOSContext> libertyContextLookupStrategy = new ChildContextLookup(LibertySSOSContext.class, true);
    private SAML20AssertionToken assertionToken;
    private LibertySSOSContext ssosContext;

    public void setLibertyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, LibertySSOSContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.libertyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Assertion token strategy may not be null");
    }

    public void setAssertionTokenStrategy(@Nonnull Function<ProfileRequestContext, SAML20AssertionToken> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.assertionTokenStrategy = (Function)Constraint.isNotNull(strategy, (String)"Assertion token strategy may not be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.assertionToken = (SAML20AssertionToken)this.assertionTokenStrategy.apply((Object)profileRequestContext);
        if (this.assertionToken == null) {
            this.log.info("{} No valid SAML20AssertionToken available within inbound WSSecurityContext", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return false;
        }
        this.ssosContext = (LibertySSOSContext)this.libertyContextLookupStrategy.apply((Object)profileRequestContext);
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.ssosContext = (LibertySSOSContext)profileRequestContext.getSubcontext(LibertySSOSContext.class, true);
        this.ssosContext.setAttestedToken((Assertion)this.assertionToken.getWrappedToken());
        this.ssosContext.setAttestedSubjectConfirmationMethod(this.assertionToken.getSubjectConfirmation().getMethod());
    }

    public class TokenStrategy
    implements Function<ProfileRequestContext, SAML20AssertionToken> {
        @Nullable
        public SAML20AssertionToken apply(@Nullable ProfileRequestContext input) {
            if (input == null) {
                return null;
            }
            WSSecurityContext wssContext = (WSSecurityContext)input.getInboundMessageContext().getSubcontext(WSSecurityContext.class);
            if (wssContext == null) {
                PopulateLibertyContext.this.log.info("{} No WSSecurityContext available within inbound message context", (Object)PopulateLibertyContext.this.getLogPrefix());
                return null;
            }
            for (Token token : wssContext.getTokens()) {
                if (!token.getValidationStatus().equals((Object)Token.ValidationStatus.VALID) || !(token instanceof SAML20AssertionToken)) continue;
                return (SAML20AssertionToken)token;
            }
            return null;
        }
    }
}

