/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.resolver.impl;

import com.google.common.base.Strings;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.AbstractAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.idp.saml.nameid.impl.TransientIdGenerationStrategy;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.saml.common.SAMLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransientIdAttributeDefinition
extends AbstractAttributeDefinition {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(TransientIdAttributeDefinition.class);
    @Nonnull
    private TransientIdGenerationStrategy idGenerator;

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.idGenerator) {
            throw new ComponentInitializationException("Id generator must be non null");
        }
    }

    @Nonnull
    public void setTransientIdGenerationStrategy(@Nonnull TransientIdGenerationStrategy generator) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idGenerator = (TransientIdGenerationStrategy)Constraint.isNotNull((Object)generator, (String)"Id generator must be non null");
    }

    @Nonnull
    public TransientIdGenerationStrategy getTransientIdGenerationStrategy() {
        return this.idGenerator;
    }

    @Nonnull
    protected IdPAttribute doAttributeDefinitionResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        String attributeRecipientID = this.getAttributeRecipientID(resolutionContext);
        String principalName = this.getPrincipal(resolutionContext);
        try {
            String transientId = this.idGenerator.generate(attributeRecipientID, principalName);
            this.log.debug("{} creating new transient ID '{}'", new Object[]{this.getLogPrefix(), transientId});
            IdPAttribute result = new IdPAttribute(this.getId());
            result.setValues(Collections.singletonList(new StringAttributeValue(transientId)));
            return result;
        }
        catch (SAMLException e) {
            throw new ResolutionException((Exception)((Object)e));
        }
    }

    @Nonnull
    @NotEmpty
    private String getAttributeRecipientID(@Nonnull AttributeResolutionContext resolutionContext) throws ResolutionException {
        String attributeRecipientID = resolutionContext.getAttributeRecipientID();
        if (Strings.isNullOrEmpty((String)attributeRecipientID)) {
            throw new ResolutionException(this.getLogPrefix() + " provided attribute recipient ID was empty");
        }
        return attributeRecipientID;
    }

    @Nonnull
    @NotEmpty
    private String getPrincipal(@Nonnull AttributeResolutionContext context) throws ResolutionException {
        String principalName = context.getPrincipal();
        if (Strings.isNullOrEmpty((String)principalName)) {
            throw new ResolutionException(this.getLogPrefix() + " provided prinicipal name was empty");
        }
        return principalName;
    }
}

