/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.nameid.impl.Base32Support;
import net.shibboleth.idp.saml.nameid.impl.PersistentIdGenerationStrategy;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.saml.common.SAMLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputedPersistentIdGenerationStrategy
extends AbstractInitializableComponent
implements PersistentIdGenerationStrategy {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ComputedPersistentIdGenerationStrategy.class);
    @NonnullAfterInit
    private byte[] salt;
    @Nonnull
    @NotEmpty
    private String algorithm = "SHA";
    @Nonnull
    private Encoding encoding = Encoding.BASE64;

    @NonnullAfterInit
    public byte[] getSalt() {
        return this.salt;
    }

    public void setSalt(@Nullable byte[] newValue) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        if (newValue != null && newValue.length > 0) {
            this.salt = newValue;
        }
    }

    public void setEncodedSalt(@Nullable String newValue) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        if (newValue != null && !newValue.isEmpty()) {
            this.salt = Base64Support.decode((String)newValue);
        }
    }

    public void setAlgorithm(@Nonnull @NotEmpty String alg) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.algorithm = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)alg), (String)"Digest algorithm cannot be null or empty");
    }

    @Nonnull
    public Encoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(@Nonnull Encoding enc) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.encoding = (Encoding)((Object)Constraint.isNotNull((Object)((Object)enc), (String)"Encoding cannot be null"));
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.getSalt()) {
            throw new ComponentInitializationException("Salt cannot be null");
        }
        if (this.getSalt().length < 16) {
            throw new ComponentInitializationException("Salt must be at least 16 bytes in size");
        }
    }

    @Override
    @Nonnull
    @NotEmpty
    public String generate(@Nonnull @NotEmpty String assertingPartyId, @Nonnull @NotEmpty String relyingPartyId, @Nonnull @NotEmpty String principalName, @Nonnull @NotEmpty String sourceId) throws SAMLException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        try {
            MessageDigest md = MessageDigest.getInstance(this.algorithm);
            md.update(relyingPartyId.getBytes());
            md.update((byte)33);
            md.update(sourceId.getBytes());
            md.update((byte)33);
            if (this.encoding == Encoding.BASE32) {
                return Base32Support.encode(md.digest(this.salt), false);
            }
            if (this.encoding == Encoding.BASE64) {
                return Base64Support.encode((byte[])md.digest(this.salt), (boolean)false);
            }
            throw new SAMLException("Desired encoding was not recognized, unable to compute ID");
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error("Digest algorithm {} is not supported", (Object)this.algorithm);
            throw new SAMLException("Digest algorithm was not supported, unable to compute ID", (Exception)e);
        }
    }

    public static enum Encoding {
        BASE64,
        BASE32;

    }
}

