/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml1.profile.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.saml.attribute.mapping.impl.SAML1AttributeDesignatorsMapperService;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.saml.saml1.core.AttributeQuery;
import org.opensaml.saml.saml1.core.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterByQueriedAttributeDesignators
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FilterByQueriedAttributeDesignators.class);
    @Nonnull
    private final SAML1AttributeDesignatorsMapperService mapperService;
    @Nonnull
    private Function<ProfileRequestContext, Request> requestLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy;
    @Nullable
    private AttributeQuery query;
    @Nullable
    private AttributeContext attributeContext;

    public FilterByQueriedAttributeDesignators(@Nonnull SAML1AttributeDesignatorsMapperService mapper) {
        this.mapperService = (SAML1AttributeDesignatorsMapperService)Constraint.isNotNull((Object)mapper, (String)"MapperService cannot be null");
        this.attributeContextLookupStrategy = Functions.compose((Function)new ChildContextLookup(AttributeContext.class), (Function)new ChildContextLookup(RelyingPartyContext.class));
        this.requestLookupStrategy = Functions.compose((Function)new MessageLookup(Request.class), (Function)new InboundMessageContextLookup());
    }

    public void setRequestLookupStrategy(@Nonnull Function<ProfileRequestContext, Request> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.requestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Request lookup strategy cannot be null");
    }

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        Request request = (Request)this.requestLookupStrategy.apply((Object)profileRequestContext);
        if (request != null) {
            this.query = request.getAttributeQuery();
        }
        if (this.query == null || this.query.getAttributeDesignators().isEmpty()) {
            this.log.debug("No AttributeDesignators found, nothing to do ");
            return false;
        }
        this.attributeContext = (AttributeContext)this.attributeContextLookupStrategy.apply((Object)profileRequestContext);
        if (this.attributeContext == null) {
            this.log.debug("{} No attribute context, no attributes to filter", (Object)this.getLogPrefix());
            return false;
        }
        if (this.attributeContext.getIdPAttributes().isEmpty()) {
            this.log.debug("{} No attributes to filter", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ArrayList<IdPAttribute> keepers = new ArrayList<IdPAttribute>(this.query.getAttributeDesignators().size());
        Multimap<String, IdPAttribute> mapped = this.mapperService.mapAttributes(this.query.getAttributeDesignators());
        this.log.debug("Query content mapped to attribute IDs: {}", (Object)mapped.keySet());
        for (IdPAttribute attribute : this.attributeContext.getIdPAttributes().values()) {
            if (mapped.containsKey((Object)attribute.getId())) {
                this.log.debug("Retaining attribute '{}' requested by query", (Object)attribute.getId());
                keepers.add(attribute);
                continue;
            }
            this.log.debug("Removing attribute '{}' not requested by query", (Object)attribute.getId());
        }
        this.attributeContext.setIdPAttributes(keepers);
    }
}

