/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.delegation.impl;

import com.google.common.base.Function;
import java.security.Principal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.navigate.ResponderIdLookupFunction;
import net.shibboleth.idp.saml.authn.principal.NameIDPrincipal;
import net.shibboleth.idp.saml.saml2.profile.delegation.impl.DelegatedAssertionLookupStrategy;
import net.shibboleth.utilities.java.support.annotation.Prototype;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLPresenterEntityContext;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.NameID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

@Prototype
public class ProcessDelegatedAssertion
extends AbstractProfileAction {
    private Logger log = LoggerFactory.getLogger(ProcessDelegatedAssertion.class);
    @Nullable
    private Function<ProfileRequestContext, String> requesterLookupStrategy = new DefaultC14NRequesterLookupFunction();
    @Nullable
    private Function<ProfileRequestContext, String> responderLookupStrategy = new ResponderIdLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, Assertion> assertionTokenStrategy = new DelegatedAssertionLookupStrategy();
    private Assertion assertion;
    private NameID nameID;

    public void setAssertionTokenStrategy(@Nonnull Function<ProfileRequestContext, Assertion> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.assertionTokenStrategy = (Function)Constraint.isNotNull(strategy, (String)"Assertion token strategy may not be null");
    }

    public void setRequesterLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.requesterLookupStrategy = strategy;
    }

    public void setResponderLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.responderLookupStrategy = strategy;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.assertion = (Assertion)this.assertionTokenStrategy.apply((Object)profileRequestContext);
        if (this.assertion == null) {
            this.log.warn("{} No valid SAML 2 Assertion available within the request context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return false;
        }
        org.opensaml.saml.saml2.core.Subject samlSubject = this.assertion.getSubject();
        if (samlSubject == null || samlSubject.getNameID() == null) {
            this.log.warn("{} SAML 2 Assertion does not contain either a Subject or a NameID", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubject");
            return false;
        }
        this.nameID = samlSubject.getNameID();
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug("{} Authenticated user based on inbound SAML 2 Assertion token with NameID: {}", (Object)this.getLogPrefix(), (Object)SerializeSupport.nodeToString((Node)XMLObjectSupport.marshall((XMLObject)this.nameID)));
            }
            catch (MarshallingException e) {
                this.log.debug("{} Could not marshall SAML 2 NameID for logging purposes", (Object)this.getLogPrefix(), (Object)e);
            }
        }
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new NameIDPrincipal(this.nameID));
        SubjectCanonicalizationContext c14n = new SubjectCanonicalizationContext();
        c14n.setSubject(subject);
        String requesterEntityID = null;
        if (this.requesterLookupStrategy != null) {
            requesterEntityID = (String)this.requesterLookupStrategy.apply((Object)profileRequestContext);
        }
        if (requesterEntityID != null) {
            this.log.debug("Resolved effective SAML requester entityID for Subject c14n: {}", (Object)requesterEntityID);
            c14n.setRequesterId(requesterEntityID);
        } else {
            this.log.warn("Unable to determine effective SAML requester for c14n, Subject c14n may fail, depending on NameID type");
        }
        if (this.responderLookupStrategy != null) {
            c14n.setResponderId((String)this.responderLookupStrategy.apply((Object)profileRequestContext));
        }
        profileRequestContext.addSubcontext((BaseContext)c14n, true);
    }

    public class DefaultC14NRequesterLookupFunction
    implements Function<ProfileRequestContext, String> {
        public String apply(ProfileRequestContext input) {
            if (ProcessDelegatedAssertion.this.nameID.getSPNameQualifier() != null) {
                ProcessDelegatedAssertion.this.log.debug("Saw delegated Assertion Subject NameID SPNameQualifier: {}", (Object)ProcessDelegatedAssertion.this.nameID.getSPNameQualifier());
                return ProcessDelegatedAssertion.this.nameID.getSPNameQualifier();
            }
            if (input != null && input.getInboundMessageContext() != null) {
                SAMLPresenterEntityContext presenterContext = (SAMLPresenterEntityContext)input.getInboundMessageContext().getSubcontext(SAMLPresenterEntityContext.class);
                if (presenterContext != null) {
                    ProcessDelegatedAssertion.this.log.debug("Saw SAML presenter entityID: {}", (Object)presenterContext.getEntityId());
                    return presenterContext.getEntityId();
                }
                return null;
            }
            return null;
        }
    }
}

