/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.profile.impl.BaseIdPInitiatedSSORequestMessageDecoder;
import net.shibboleth.idp.saml.profile.impl.IdPInitiatedSSORequest;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.binding.decoding.SAMLMessageDecoder;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IdPInitiatedSSORequestMessageDecoder
extends BaseIdPInitiatedSSORequestMessageDecoder<SAMLObject>
implements SAMLMessageDecoder {
    @Nonnull
    @NotEmpty
    private static final String BINDING_URI = "urn:mace:shibboleth:2.0:profiles:AuthnRequest";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(IdPInitiatedSSORequestMessageDecoder.class);
    private final SAMLObjectBuilder<AuthnRequest> requestBuilder;
    private final SAMLObjectBuilder<Issuer> issuerBuilder;
    private final SAMLObjectBuilder<NameIDPolicy> nipBuilder;
    @Nullable
    private IdPInitiatedSSORequest ssoRequest;

    public IdPInitiatedSSORequestMessageDecoder() {
        XMLObjectBuilderFactory factory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        this.requestBuilder = (SAMLObjectBuilder)factory.getBuilderOrThrow(AuthnRequest.DEFAULT_ELEMENT_NAME);
        this.issuerBuilder = (SAMLObjectBuilder)factory.getBuilderOrThrow(Issuer.DEFAULT_ELEMENT_NAME);
        this.nipBuilder = (SAMLObjectBuilder)factory.getBuilderOrThrow(NameIDPolicy.DEFAULT_ELEMENT_NAME);
    }

    @Nonnull
    @NotEmpty
    public String getBindingURI() {
        return BINDING_URI;
    }

    @Nullable
    protected IdPInitiatedSSORequest getIdPInitiatedSSORequest() {
        return this.ssoRequest;
    }

    protected void doDecode() throws MessageDecodingException {
        this.ssoRequest = this.buildIdPInitiatedSSORequest();
        MessageContext messageContext = new MessageContext();
        messageContext.setMessage((Object)this.buildAuthnRequest());
        this.populateBindingContext((MessageContext<SAMLObject>)messageContext);
        this.setMessageContext(messageContext);
    }

    @Nonnull
    protected AuthnRequest buildAuthnRequest() throws MessageDecodingException {
        AuthnRequest authnRequest = (AuthnRequest)this.requestBuilder.buildObject();
        Issuer requestIssuer = (Issuer)this.issuerBuilder.buildObject();
        requestIssuer.setValue(this.ssoRequest.getEntityId());
        authnRequest.setIssuer(requestIssuer);
        NameIDPolicy nip = (NameIDPolicy)this.nipBuilder.buildObject();
        nip.setAllowCreate(Boolean.valueOf(true));
        authnRequest.setNameIDPolicy(nip);
        authnRequest.setAssertionConsumerServiceURL(this.ssoRequest.getAssertionConsumerServiceURL());
        authnRequest.setIssueInstant(new DateTime(this.ssoRequest.getTime(), (Chronology)ISOChronology.getInstanceUTC()));
        authnRequest.setVersion(SAMLVersion.VERSION_20);
        authnRequest.setID(this.getMessageID());
        return authnRequest;
    }

    protected void populateBindingContext(@Nonnull MessageContext<SAMLObject> messageContext) {
        String relayState = this.ssoRequest.getRelayState();
        this.log.debug("Decoded SAML RelayState of: {}", (Object)relayState);
        SAMLBindingContext bindingContext = (SAMLBindingContext)messageContext.getSubcontext(SAMLBindingContext.class, true);
        bindingContext.setRelayState(relayState);
        bindingContext.setBindingUri(this.getBindingURI());
        bindingContext.setBindingDescriptor(this.getBindingDescriptor());
        bindingContext.setHasBindingSignature(false);
        bindingContext.setIntendedDestinationEndpointURIRequired(false);
    }

    @Override
    @Nullable
    protected String getMessageToLog() {
        SAMLObject message = (SAMLObject)this.getMessageContext().getMessage();
        if (message == null) {
            this.log.warn("Decoded message was null, nothing to log");
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("SAML 2 IdP-initiated request was: " + this.ssoRequest.toString());
        builder.append("\nSynthetically constructed SAML 2 AuthnRequest was: \n");
        try {
            Element dom = XMLObjectSupport.marshall((XMLObject)message);
            builder.append(SerializeSupport.prettyPrintXML((Node)dom));
            return builder.toString();
        }
        catch (MarshallingException e) {
            this.log.error("Unable to marshall message for logging purposes", (Throwable)e);
            return null;
        }
    }
}

