/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.resolver.impl;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.idp.saml.attribute.resolver.impl.ComputedIDDataConnector;
import net.shibboleth.idp.saml.nameid.impl.JDBCPersistentIdStoreEx;
import net.shibboleth.idp.saml.nameid.impl.StoredPersistentIdGenerationStrategy;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonNegative;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import org.opensaml.saml.common.SAMLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoredIDDataConnector
extends ComputedIDDataConnector {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StoredIDDataConnector.class);
    @Nonnull
    private final JDBCPersistentIdStoreEx idStore = new JDBCPersistentIdStoreEx();
    @Nonnull
    private final StoredPersistentIdGenerationStrategy storedIdStrategy;

    public StoredIDDataConnector() {
        this.idStore.setVerifyDatabase(false);
        this.storedIdStrategy = new StoredPersistentIdGenerationStrategy();
    }

    @NonnullAfterInit
    public DataSource getDataSource() {
        return this.idStore.getDataSource();
    }

    public void setDataSource(@Nonnull DataSource source) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idStore.setDataSource(source);
    }

    @Nonnull
    public JDBCPersistentIdStoreEx getStoredIDStore() {
        return this.idStore;
    }

    @Nonnull
    @NonnullElements
    public Collection<String> getRetryableErrors() {
        return this.idStore.getRetryableErrors();
    }

    public void setRetryableErrors(@Nullable @NonnullElements Collection<String> errors) {
        this.idStore.setRetryableErrors(errors);
    }

    @Duration
    @NonNegative
    public long getQueryTimeout() {
        return this.idStore.getQueryTimeout();
    }

    @Duration
    public void setQueryTimeout(@Duration @NonNegative long timeout) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idStore.setQueryTimeout(timeout);
    }

    public int getTransactionRetries() {
        return this.idStore.getTransactionRetries();
    }

    public void setTransactionRetries(@NonNegative int retries) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idStore.setTransactionRetries(retries);
    }

    public boolean getFailFast() {
        return this.idStore.getVerifyDatabase();
    }

    public void setFailFast(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idStore.setVerifyDatabase(flag);
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        if (this.getSalt() == null) {
            this.clearComputedIdStrategy();
        }
        super.doInitialize();
        this.idStore.initialize();
        this.storedIdStrategy.setIDStore(this.idStore);
        this.storedIdStrategy.setComputedIdStrategy(this.getComputedIdStrategy());
        this.storedIdStrategy.initialize();
    }

    @Override
    protected void doDestroy() {
        this.storedIdStrategy.destroy();
        this.idStore.destroy();
        super.doDestroy();
    }

    @Override
    @Nullable
    protected Map<String, IdPAttribute> doDataConnectorResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        String principalName = resolutionContext.getPrincipal();
        if (Strings.isNullOrEmpty((String)principalName)) {
            this.log.warn("{} No principal available, skipping ID creation", (Object)this.getLogPrefix());
            return null;
        }
        String sourceId = this.resolveSourceAttribute(workContext);
        if (Strings.isNullOrEmpty((String)sourceId)) {
            return null;
        }
        String attributeIssuerID = resolutionContext.getAttributeIssuerID();
        if (Strings.isNullOrEmpty((String)attributeIssuerID)) {
            this.log.warn("{} Could not get attribute issuer ID, skipping ID creation", (Object)this.getLogPrefix());
            return null;
        }
        String attributeRecipientID = resolutionContext.getAttributeRecipientGroupID();
        if (Strings.isNullOrEmpty((String)attributeRecipientID)) {
            attributeRecipientID = resolutionContext.getAttributeRecipientID();
        }
        if (Strings.isNullOrEmpty((String)attributeRecipientID)) {
            this.log.warn("{} Could not get attribute recipient or group ID, skipping ID creation", (Object)this.getLogPrefix());
            return null;
        }
        try {
            return this.encodeAsAttribute(this.storedIdStrategy.generate(attributeIssuerID, attributeRecipientID, principalName, sourceId));
        }
        catch (SAMLException e) {
            throw new ResolutionException((Exception)((Object)e));
        }
    }
}

