/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.audit.impl;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.ArtifactResponse;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.SessionIndex;

public class SessionIndexAuditExtractor
implements Function<ProfileRequestContext, Collection<String>> {
    @Nonnull
    private final Function<ProfileRequestContext, SAMLObject> messageLookupStrategy;

    public SessionIndexAuditExtractor(@Nonnull Function<ProfileRequestContext, SAMLObject> strategy) {
        this.messageLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Message lookup strategy cannot be null");
    }

    @Nullable
    public Collection<String> apply(@Nullable ProfileRequestContext input) {
        SAMLObject message = (SAMLObject)this.messageLookupStrategy.apply((Object)input);
        if (message != null) {
            ArrayList<String> indexes = new ArrayList<String>(1);
            if (message instanceof ArtifactResponse) {
                message = ((ArtifactResponse)message).getMessage();
            }
            if (message instanceof Response) {
                for (Assertion assertion : ((Response)message).getAssertions()) {
                    for (AuthnStatement statement : assertion.getAuthnStatements()) {
                        if (statement.getSessionIndex() == null) continue;
                        indexes.add(statement.getSessionIndex());
                    }
                }
            } else if (message instanceof LogoutRequest) {
                for (SessionIndex index : ((LogoutRequest)message).getSessionIndexes()) {
                    if (index == null || index.getSessionIndex() == null) continue;
                    indexes.add(index.getSessionIndex());
                }
            }
            return indexes;
        }
        return Collections.emptyList();
    }
}

