/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;

@ThreadSafe
public class IdPInitiatedSSORequest {
    @Nonnull
    @NotEmpty
    private final String entityId;
    @Nullable
    private final String acsURL;
    @Nullable
    private final String relayState;
    @Positive
    private final long time;

    public IdPInitiatedSSORequest(@Nonnull @NotEmpty String newEntityId, @Nullable String url, @Nullable String target, @Nullable @Positive Long newTime) {
        this.entityId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)newEntityId), (String)"Service provider ID cannot be null or empty");
        this.acsURL = StringSupport.trimOrNull((String)url);
        this.relayState = StringSupport.trimOrNull((String)target);
        this.time = newTime != null ? Constraint.isGreaterThan((long)0L, (long)newTime, (String)"Time must be greater than 0") : System.currentTimeMillis();
    }

    @Nonnull
    @NotEmpty
    public String getEntityId() {
        return this.entityId;
    }

    @Nullable
    public String getAssertionConsumerServiceURL() {
        return this.acsURL;
    }

    @Nullable
    public String getRelayState() {
        return this.relayState;
    }

    public long getTime() {
        return this.time;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("entityId", (Object)this.entityId).add("acsURL", (Object)this.acsURL).add("relayState", (Object)this.relayState).add("time", (Object)new DateTime(this.time, (Chronology)ISOChronology.getInstanceUTC())).toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.entityId.hashCode();
        result = this.acsURL != null ? 31 * result + this.acsURL.hashCode() : 31 * result + 0;
        result = this.relayState != null ? 31 * result + this.relayState.hashCode() : 31 * result + 0;
        result = 31 * result + (int)(this.time ^ this.time >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdPInitiatedSSORequest)) {
            return false;
        }
        IdPInitiatedSSORequest other = (IdPInitiatedSSORequest)obj;
        return Objects.equals(this.entityId, other.entityId) && Objects.equals(this.acsURL, other.acsURL) && Objects.equals(this.relayState, other.relayState) && this.time == other.time;
    }
}

