/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.context.SpringRequestContext;
import net.shibboleth.idp.saml.binding.BindingDescriptor;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.encoder.MessageEncoder;
import org.opensaml.profile.action.MessageEncoderFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;

@ThreadSafeAfterInit
public class SpringAwareMessageEncoderFactory
extends AbstractInitializableComponent
implements MessageEncoderFactory {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SpringAwareMessageEncoderFactory.class);
    @Nonnull
    @NonnullElements
    private ListMultimap<String, BindingDescriptor> bindingMap = ArrayListMultimap.create();

    public void setBindings(@Nonnull @NonnullElements List<BindingDescriptor> bindings) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(bindings, (String)"Binding descriptor list cannot be null");
        this.bindingMap.clear();
        for (BindingDescriptor binding : bindings) {
            if (binding == null || binding.getId() == null) continue;
            this.bindingMap.put((Object)binding.getId(), (Object)binding);
        }
    }

    @Nullable
    public MessageEncoder getMessageEncoder(@Nonnull ProfileRequestContext profileRequestContext) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        SpringRequestContext springContext = (SpringRequestContext)profileRequestContext.getSubcontext(SpringRequestContext.class);
        if (springContext == null || springContext.getRequestContext() == null) {
            this.log.warn("No outbound message context, unable to lookup message encoder");
            return null;
        }
        if (profileRequestContext.getOutboundMessageContext() == null) {
            this.log.warn("No outbound message context, unable to lookup message encoder");
            return null;
        }
        SAMLBindingContext bindingContext = (SAMLBindingContext)profileRequestContext.getOutboundMessageContext().getSubcontext(SAMLBindingContext.class);
        if (bindingContext == null || bindingContext.getBindingUri() == null) {
            this.log.warn("Binding URI was not available, unable to lookup message encoder");
            return null;
        }
        this.log.debug("Looking up message encoder based on binding URI: {}", (Object)bindingContext.getBindingUri());
        List bindings = this.bindingMap.get((Object)bindingContext.getBindingUri());
        for (BindingDescriptor binding : bindings) {
            if (binding.getEncoderBeanId() == null) continue;
            try {
                return (MessageEncoder)springContext.getRequestContext().getActiveFlow().getApplicationContext().getBean(binding.getEncoderBeanId(), MessageEncoder.class);
            }
            catch (BeansException e) {
                this.log.warn("Error instantiating message encoder from bean ID {}", (Object)binding.getEncoderBeanId(), (Object)e);
            }
        }
        this.log.warn("Failed to find a message encoder based on binding URI: {}", (Object)bindingContext.getBindingUri());
        return null;
    }
}

