/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.delegation.messaging.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.idp.saml.saml2.profile.delegation.impl.LibertyConstants;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.openliberty.xmltooling.soapbinding.Sender;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.messaging.context.SAMLPresenterEntityContext;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessSenderHandler
extends AbstractMessageHandler {
    private Logger log = LoggerFactory.getLogger(ProcessSenderHandler.class);

    protected void doInvoke(MessageContext messageContext) throws MessageHandlerException {
        Sender header = this.getSender(messageContext);
        String headerValue = header != null ? StringSupport.trimOrNull((String)header.getProviderID()) : null;
        this.log.debug("Extracted inbound Liberty ID-WSF Sender providerId value: {}", (Object)headerValue);
        if (header != null && headerValue != null) {
            ((SAMLPresenterEntityContext)messageContext.getSubcontext(SAMLPresenterEntityContext.class, true)).setEntityId(headerValue);
            SOAPMessagingSupport.registerUnderstoodHeader((MessageContext)messageContext, (XMLObject)header);
        }
    }

    protected Sender getSender(@Nonnull MessageContext messageContext) {
        List senders = SOAPMessagingSupport.getInboundHeaderBlock((MessageContext)messageContext, (QName)LibertyConstants.SOAP_BINDING_SENDER_ELEMENT_NAME);
        if (senders != null && !senders.isEmpty()) {
            return (Sender)senders.get(0);
        }
        return null;
    }
}

