/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.attribute.AttributeDecodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.attribute.filter.AttributeFilter;
import net.shibboleth.idp.attribute.filter.AttributeFilterException;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoder;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.idp.attribute.transcoding.TranscoderSupport;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.authn.AbstractValidationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.principal.IdPAttributePrincipal;
import net.shibboleth.idp.authn.principal.ProxyAuthenticationPrincipal;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.saml.authn.principal.AuthnContextClassRefPrincipal;
import net.shibboleth.idp.saml.authn.principal.AuthnContextDeclRefPrincipal;
import net.shibboleth.idp.saml.authn.principal.NameIDPrincipal;
import net.shibboleth.idp.saml.profile.context.navigate.SAMLMetadataContextLookupFunction;
import net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.idp.saml.saml2.profile.impl.SAMLAuthnContext;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.opensaml.core.xml.schema.XSURI;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.RecursiveTypedParentContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.ProxyRestriction;
import org.opensaml.saml.saml2.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateSAMLAuthentication
extends AbstractValidationAction {
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_METRIC_NAME = "net.shibboleth.idp.authn.saml";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateSAMLAuthentication.class);
    @Nullable
    private ReloadableService<AttributeTranscoderRegistry> transcoderRegistry;
    @Nullable
    private ReloadableService<AttributeFilter> attributeFilterService;
    @Nullable
    private MetadataResolver metadataResolver;
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, Collection<IdPAttribute>> attributeExtractionStrategy;
    @Nullable
    private SAMLAuthnContext samlAuthnContext;
    @Nullable
    private BrowserSSOProfileConfiguration profileConfiguration;
    @Nullable
    private Function<AuthnContext, Collection<Principal>> authnContextTranslator;
    @Nullable
    private Function<ProfileRequestContext, Collection<Principal>> authnContextTranslatorEx;
    @Nullable
    private AttributeContext attributeContext;

    public ValidateSAMLAuthentication() {
        this.setMetricName(DEFAULT_METRIC_NAME);
        this.relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    }

    public void setTranscoderRegistry(@Nullable ReloadableService<AttributeTranscoderRegistry> registry) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.transcoderRegistry = registry;
    }

    public void setAttributeFilter(@Nullable ReloadableService<AttributeFilter> filterService) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributeFilterService = filterService;
    }

    public void setMetadataResolver(@Nullable MetadataResolver resolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.metadataResolver = resolver;
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setAttributeExtractionStrategy(@Nullable Function<ProfileRequestContext, Collection<IdPAttribute>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributeExtractionStrategy = strategy;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        if (authenticationContext.getAttemptedFlow() == null) {
            this.log.debug("{} No attempted flow within authentication context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.samlAuthnContext = (SAMLAuthnContext)authenticationContext.getSubcontext(SAMLAuthnContext.class);
        if (this.samlAuthnContext == null) {
            this.log.debug("{} No SAMLAuthnContext available within authentication context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidCredentials");
            return false;
        }
        RelyingPartyContext rpContext = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (rpContext == null) {
            this.log.error("{} Unable to locate RelyingPartyContext", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        if (rpContext.getProfileConfig() == null) {
            this.log.error("{} Unable to locate profile configuration", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        if (!(rpContext.getProfileConfig() instanceof BrowserSSOProfileConfiguration)) {
            this.log.error("{} Not a SAML 2 profile configuration", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        this.profileConfiguration = (BrowserSSOProfileConfiguration)rpContext.getProfileConfig();
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        this.recordSuccess(profileRequestContext);
        if (this.transcoderRegistry != null) {
            this.processAttributes(profileRequestContext);
        }
        if (this.attributeExtractionStrategy != null) {
            this.log.debug("{} Applying custom extraction strategy function", (Object)this.getLogPrefix());
            if (this.attributeContext == null) {
                this.attributeContext = (AttributeContext)((RelyingPartyContext)profileRequestContext.getSubcontext(RelyingPartyContext.class)).getSubcontext(AttributeContext.class, true);
            }
            ArrayList attributes = new ArrayList(this.attributeContext.getIdPAttributes().values());
            Collection<IdPAttribute> newAttributes = this.attributeExtractionStrategy.apply(profileRequestContext);
            if (newAttributes != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("{} Extracted attributes with custom strategy: {}", (Object)this.getLogPrefix(), newAttributes.stream().map(IdPAttribute::getId).collect(Collectors.toUnmodifiableList()));
                }
                attributes.addAll(newAttributes);
                this.attributeContext.setIdPAttributes(attributes);
            }
        }
        this.authnContextTranslator = this.profileConfiguration.getAuthnContextTranslationStrategy(profileRequestContext);
        this.authnContextTranslatorEx = this.profileConfiguration.getAuthnContextTranslationStrategyEx(profileRequestContext);
        this.buildAuthenticationResult(profileRequestContext, authenticationContext);
        if (authenticationContext.getAuthenticationResult() != null && this.profileConfiguration.isProxiedAuthnInstant(profileRequestContext)) {
            this.log.debug("{} Resetting authentication time to proxied value: {}", (Object)this.getLogPrefix(), (Object)this.samlAuthnContext.getAuthnStatement().getAuthnInstant());
            if (this.samlAuthnContext.getAuthnStatement().getAuthnInstant() != null) {
                authenticationContext.getAuthenticationResult().setAuthenticationInstant(this.samlAuthnContext.getAuthnStatement().getAuthnInstant());
            }
        }
    }

    @Nonnull
    protected Subject populateSubject(@Nonnull Subject subject) {
        if (this.samlAuthnContext.getSubject() != null && this.samlAuthnContext.getSubject().getNameID() != null) {
            subject.getPrincipals().add((Principal)new NameIDPrincipal(this.samlAuthnContext.getSubject().getNameID()));
        }
        AuthnContext authnContext = this.samlAuthnContext.getAuthnStatement().getAuthnContext();
        if (this.authnContextTranslatorEx != null) {
            Collection<Principal> translated = this.authnContextTranslatorEx.apply((ProfileRequestContext)this.samlAuthnContext.getParent().getParent());
            if (translated != null) {
                subject.getPrincipals().addAll(translated);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("{} Added translated Principals: {}", (Object)this.getLogPrefix(), translated.stream().map(Principal::getName).collect(Collectors.toUnmodifiableList()));
                }
            }
        } else if (this.authnContextTranslator != null) {
            Collection<Principal> translated = this.authnContextTranslator.apply(authnContext);
            if (translated != null) {
                subject.getPrincipals().addAll(translated);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("{} Added translated AuthnContext Principals: {}", (Object)this.getLogPrefix(), translated.stream().map(Principal::getName).collect(Collectors.toUnmodifiableList()));
                }
            }
        } else if (authnContext.getAuthnContextClassRef() != null) {
            String classRef = authnContext.getAuthnContextClassRef().getURI();
            if (classRef != null) {
                subject.getPrincipals().add((Principal)new AuthnContextClassRefPrincipal(classRef));
                this.log.debug("{} Added AuthnContextClassRef from assertion: {}", (Object)this.getLogPrefix(), (Object)classRef);
            }
        } else if (authnContext.getAuthnContextDeclRef() != null) {
            String declRef = authnContext.getAuthnContextDeclRef().getURI();
            if (declRef != null) {
                subject.getPrincipals().add((Principal)new AuthnContextDeclRefPrincipal(declRef));
                this.log.debug("{} Added AuthnContextDeclRef from assertion: {}", (Object)this.getLogPrefix(), (Object)declRef);
            }
        } else {
            this.log.warn("{} No AuthnContext information usable from assertion", (Object)this.getLogPrefix());
        }
        subject.getPrincipals().add((Principal)this.buildProxyPrincipal(authnContext));
        if (this.attributeContext != null && !this.attributeContext.getIdPAttributes().isEmpty()) {
            this.log.debug("{} Adding filtered inbound attributes to Subject", (Object)this.getLogPrefix());
            subject.getPrincipals().addAll(this.attributeContext.getIdPAttributes().values().stream().map(a -> new IdPAttributePrincipal(a)).collect(Collectors.toUnmodifiableList()));
        }
        return subject;
    }

    @Nonnull
    private ProxyAuthenticationPrincipal buildProxyPrincipal(@Nonnull AuthnContext authnContext) {
        ProxyAuthenticationPrincipal proxied = new ProxyAuthenticationPrincipal();
        Assertion assertion = (Assertion)this.samlAuthnContext.getAuthnStatement().getParent();
        if (!authnContext.getAuthenticatingAuthorities().isEmpty()) {
            proxied.getAuthorities().addAll(authnContext.getAuthenticatingAuthorities().stream().map(XSURI::getURI).filter(aa -> !Strings.isNullOrEmpty((String)aa)).collect(Collectors.toUnmodifiableList()));
        }
        proxied.getAuthorities().add(assertion.getIssuer().getValue());
        ProxyRestriction condition = assertion.getConditions().getProxyRestriction();
        if (condition != null) {
            proxied.setProxyCount(condition.getProxyCount());
            if (condition.getAudiences() != null) {
                proxied.getAudiences().addAll(condition.getAudiences().stream().map(XSURI::getURI).filter(a -> !Strings.isNullOrEmpty((String)a)).collect(Collectors.toUnmodifiableList()));
            }
        }
        return proxied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAttributes(@Nonnull ProfileRequestContext profileRequestContext) {
        this.log.debug("{} Decoding incoming SAML Attributes", (Object)this.getLogPrefix());
        HashMultimap mapped = HashMultimap.create();
        ServiceableComponent component = null;
        try {
            component = this.transcoderRegistry.getServiceableComponent();
            if (component == null) {
                this.log.error("Attribute transcoder service unavailable");
                return;
            }
            Response response = (Response)profileRequestContext.getInboundMessageContext().getMessage();
            for (Assertion assertion : response.getAssertions()) {
                for (AttributeStatement statement : assertion.getAttributeStatements()) {
                    for (Attribute designator : statement.getAttributes()) {
                        try {
                            this.decodeAttribute((AttributeTranscoderRegistry)component.getComponent(), profileRequestContext, designator, (Multimap<String, IdPAttribute>)mapped);
                        }
                        catch (AttributeDecodingException e) {
                            this.log.error("{} Error decoding inbound Attribute", (Object)this.getLogPrefix(), (Object)e);
                        }
                    }
                }
            }
        }
        finally {
            if (component != null) {
                component.unpinComponent();
            }
        }
        this.log.debug("{} Incoming SAML Attributes mapped to attribute IDs: {}", (Object)this.getLogPrefix(), (Object)mapped.keySet());
        if (!mapped.isEmpty()) {
            this.attributeContext = (AttributeContext)((RelyingPartyContext)profileRequestContext.getSubcontext(RelyingPartyContext.class)).getSubcontext(AttributeContext.class, true);
            this.attributeContext.setUnfilteredIdPAttributes(mapped.values());
            this.attributeContext.setIdPAttributes(null);
            this.filterAttributes(profileRequestContext);
        }
    }

    private void decodeAttribute(@Nonnull AttributeTranscoderRegistry registry, @Nonnull ProfileRequestContext profileRequestContext, @Nonnull Attribute input, @Nonnull @NonnullElements @Live Multimap<String, IdPAttribute> results) throws AttributeDecodingException {
        Collection transcodingRules = registry.getTranscodingRules((Object)input);
        if (transcodingRules.isEmpty()) {
            this.log.info("{} No transcoding rule for Attribute '{}'", (Object)this.getLogPrefix(), (Object)input.getName());
            return;
        }
        for (TranscodingRule rules : transcodingRules) {
            AttributeTranscoder transcoder = TranscoderSupport.getTranscoder((TranscodingRule)rules);
            IdPAttribute decodedAttribute = transcoder.decode(profileRequestContext, (Object)input, rules);
            if (decodedAttribute == null) continue;
            results.put((Object)decodedAttribute.getId(), (Object)decodedAttribute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterAttributes(@Nonnull ProfileRequestContext profileRequestContext) {
        if (this.attributeFilterService == null) {
            this.log.warn("{} No AttributeFilter service provided", (Object)this.getLogPrefix());
            return;
        }
        AttributeFilterContext filterContext = (AttributeFilterContext)profileRequestContext.getSubcontext(AttributeFilterContext.class, true);
        this.populateFilterContext(profileRequestContext, filterContext);
        ServiceableComponent component = null;
        try {
            component = this.attributeFilterService.getServiceableComponent();
            if (null == component) {
                this.log.error("{} Error while filtering inbound attributes: Invalid Attribute Filter configuration", (Object)this.getLogPrefix());
            } else {
                AttributeFilter filter = (AttributeFilter)component.getComponent();
                filter.filterAttributes(filterContext);
                filterContext.getParent().removeSubcontext((BaseContext)filterContext);
                this.attributeContext.setIdPAttributes(filterContext.getFilteredIdPAttributes().values());
            }
        }
        catch (AttributeFilterException e) {
            this.log.error("{} Error while filtering inbound attributes", (Object)this.getLogPrefix(), (Object)e);
        }
        finally {
            if (null != component) {
                component.unpinComponent();
            }
        }
    }

    private void populateFilterContext(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AttributeFilterContext filterContext) {
        filterContext.setDirection(AttributeFilterContext.Direction.INBOUND).setPrefilteredIdPAttributes(this.attributeContext.getUnfilteredIdPAttributes().values()).setMetadataResolver(this.metadataResolver).setRequesterMetadataContextLookupStrategy(null).setIssuerMetadataContextLookupStrategy(new SAMLMetadataContextLookupFunction().compose((Function)new RecursiveTypedParentContextLookup(ProfileRequestContext.class))).setProxiedRequesterContextLookupStrategy(null).setAttributeIssuerID((String)this.getResponderLookupStrategy().apply(profileRequestContext)).setAttributeRecipientID((String)this.getRequesterLookupStrategy().apply(profileRequestContext));
    }
}

