/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.session.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.json.JsonObject;
import javax.json.stream.JsonGenerator;
import net.shibboleth.idp.saml.session.SAML2SPSession;
import net.shibboleth.idp.session.AbstractSPSessionSerializer;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLRuntimeException;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.saml2.core.NameID;
import org.w3c.dom.Node;

@ThreadSafeAfterInit
public class SAML2SPSessionSerializer
extends AbstractSPSessionSerializer {
    @Nonnull
    @NotEmpty
    private static final String NAMEID_FIELD = "nam";
    @Nonnull
    @NotEmpty
    private static final String SESSION_INDEX_FIELD = "ix";
    @Nonnull
    private static final Map<String, Object> NO_XML_DECL_PARAMS = Collections.singletonMap("xml-declaration", Boolean.FALSE);
    @Nonnull
    private ParserPool parserPool = (ParserPool)Constraint.isNotNull((Object)XMLObjectProviderRegistrySupport.getParserPool(), (String)"ParserPool cannot be null");

    public SAML2SPSessionSerializer(@Nonnull @ParameterName(name="offset") Duration offset) {
        super(offset);
    }

    public void setParserPool(@Nonnull ParserPool pool) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.parserPool = (ParserPool)Constraint.isNotNull((Object)pool, (String)"ParserPool cannot be null");
    }

    protected void doSerializeAdditional(@Nonnull SPSession instance, @Nonnull JsonGenerator generator) {
        SAML2SPSession saml2Session = (SAML2SPSession)instance;
        try {
            generator.write(NAMEID_FIELD, SerializeSupport.nodeToString((Node)XMLObjectSupport.marshall((XMLObject)saml2Session.getNameID()), NO_XML_DECL_PARAMS));
            generator.write(SESSION_INDEX_FIELD, saml2Session.getSessionIndex());
        }
        catch (MarshallingException e) {
            throw new XMLRuntimeException("Error marshalling and serializing NameID", (Exception)((Object)e));
        }
    }

    @Nonnull
    protected SPSession doDeserialize(@Nonnull JsonObject obj, @Nonnull @NotEmpty String id, @Nonnull Instant creation, @Nonnull Instant expiration) throws IOException {
        String rawNameID = obj.getString(NAMEID_FIELD);
        String sessionIndex = obj.getString(SESSION_INDEX_FIELD);
        try {
            XMLObject nameID = XMLObjectSupport.unmarshallFromReader((ParserPool)this.parserPool, (Reader)new StringReader(rawNameID));
            if (nameID instanceof NameID) {
                return new SAML2SPSession(id, creation, expiration, (NameID)nameID, sessionIndex);
            }
            throw new IOException("XMLObject stored in NameID field was not a NameID");
        }
        catch (XMLParserException | UnmarshallingException e) {
            throw new IOException("Unable to parse or unmarshall NameID field", e);
        }
    }
}

