/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.transcoding.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.testing.MockApplicationContext;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.ByteAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.IdPRequestedAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.XMLObjectAttributeValue;
import net.shibboleth.idp.attribute.transcoding.BasicNamingFunction;
import net.shibboleth.idp.attribute.transcoding.TranscoderSupport;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.attribute.transcoding.impl.AttributeTranscoderRegistryImpl;
import net.shibboleth.idp.saml.attribute.transcoding.AbstractSAML2AttributeTranscoder;
import net.shibboleth.idp.saml.attribute.transcoding.SAMLEncoderSupport;
import net.shibboleth.idp.saml.attribute.transcoding.impl.SAML2XMLObjectAttributeTranscoder;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeValue;
import org.opensaml.saml.saml2.metadata.RequestedAttribute;
import org.springframework.context.ApplicationContext;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class SAML2XMLObjectAttributeTranscoderTest
extends OpenSAMLInitBaseTestCase {
    private AttributeTranscoderRegistryImpl registry;
    private SAMLObjectBuilder<AttributeValue> anyBuilder;
    private XMLObjectBuilder<XSString> stringBuilder;
    private SAMLObjectBuilder<Attribute> attributeBuilder;
    private SAMLObjectBuilder<RequestedAttribute> reqAttributeBuilder;
    private static final String ATTR_NAME = "foo";
    private static final String ATTR_NAMEFORMAT = "Namespace";
    private static final String ATTR_FRIENDLYNAME = "friendly";
    private static final String STRING_1 = "Value The First";
    private static final String STRING_2 = "Second string the value is";

    @BeforeClass
    public void setUp() throws ComponentInitializationException {
        XMLObjectBuilderFactory bf = XMLObjectProviderRegistrySupport.getBuilderFactory();
        this.anyBuilder = (SAMLObjectBuilder)bf.getBuilderOrThrow(AttributeValue.DEFAULT_ELEMENT_NAME);
        this.stringBuilder = bf.getBuilderOrThrow(XSString.TYPE_NAME);
        this.attributeBuilder = (SAMLObjectBuilder)bf.getBuilderOrThrow(Attribute.TYPE_NAME);
        this.reqAttributeBuilder = (SAMLObjectBuilder)bf.getBuilderOrThrow(RequestedAttribute.TYPE_NAME);
        this.registry = new AttributeTranscoderRegistryImpl();
        this.registry.setId("test");
        SAML2XMLObjectAttributeTranscoder transcoder = new SAML2XMLObjectAttributeTranscoder();
        transcoder.initialize();
        this.registry.setNamingRegistry(Collections.singletonList(new BasicNamingFunction(transcoder.getEncodedType(), (Function)new AbstractSAML2AttributeTranscoder.NamingFunction())));
        HashMap<String, Object> ruleset1 = new HashMap<String, Object>();
        ruleset1.put("id", ATTR_NAME);
        ruleset1.put("transcoder", transcoder);
        ruleset1.put("saml2.encodeType", true);
        ruleset1.put("saml2.name", ATTR_NAME);
        ruleset1.put("saml2.nameFormat", ATTR_NAMEFORMAT);
        ruleset1.put("saml2.friendlyName", ATTR_FRIENDLYNAME);
        this.registry.setTranscoderRegistry(Collections.singletonList(new TranscodingRule(ruleset1)));
        this.registry.setApplicationContext((ApplicationContext)new MockApplicationContext());
        this.registry.initialize();
    }

    @AfterClass
    public void tearDown() {
        this.registry.destroy();
        this.registry = null;
    }

    @Test
    public void emptyEncode() throws Exception {
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_NAME);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        Attribute attr = (Attribute)TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, Attribute.class, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getName(), (String)ATTR_NAME);
        Assert.assertEquals((String)attr.getNameFormat(), (String)ATTR_NAMEFORMAT);
        Assert.assertEquals((String)attr.getFriendlyName(), (String)ATTR_FRIENDLYNAME);
        Assert.assertTrue((boolean)attr.getAttributeValues().isEmpty());
    }

    @Test
    public void emptyDecode() throws Exception {
        Attribute samlAttribute = (Attribute)this.attributeBuilder.buildObject();
        samlAttribute.setName(ATTR_NAME);
        samlAttribute.setNameFormat(ATTR_NAMEFORMAT);
        Collection rulesets = this.registry.getTranscodingRules((Object)samlAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)samlAttribute, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getId(), (String)ATTR_NAME);
        Assert.assertTrue((boolean)attr.getValues().isEmpty());
    }

    @Test
    public void emptyRequestedDecode() throws Exception {
        RequestedAttribute samlAttribute = (RequestedAttribute)this.reqAttributeBuilder.buildObject();
        samlAttribute.setName(ATTR_NAME);
        samlAttribute.setNameFormat(ATTR_NAMEFORMAT);
        samlAttribute.setIsRequired(Boolean.valueOf(true));
        Collection rulesets = this.registry.getTranscodingRules((Object)samlAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)samlAttribute, ruleset);
        Assert.assertTrue((boolean)(attr instanceof IdPRequestedAttribute));
        Assert.assertEquals((String)attr.getId(), (String)ATTR_NAME);
        Assert.assertTrue((boolean)((IdPRequestedAttribute)attr).isRequired());
        Assert.assertTrue((boolean)attr.getValues().isEmpty());
    }

    @Test(expectedExceptions={AttributeEncodingException.class})
    public void inappropriate() throws Exception {
        final int[] intArray = new int[]{1, 2, 3, 4};
        List<1> values = List.of(new ByteAttributeValue(new byte[]{1, 2, 3}), new IdPAttributeValue(){

            public Object getNativeValue() {
                return intArray;
            }

            public String getDisplayValue() {
                return intArray.toString();
            }
        });
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_NAME);
        inputAttribute.setValues(values);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, Attribute.class, ruleset);
    }

    @Test
    public void single() throws Exception {
        List<XMLObjectAttributeValue> values = List.of(new ByteAttributeValue(new byte[]{1, 2, 3}), SAML2XMLObjectAttributeTranscoderTest.objectFor(STRING_1));
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_NAME);
        inputAttribute.setValues(values);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        Attribute attr = (Attribute)TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, Attribute.class, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getName(), (String)ATTR_NAME);
        Assert.assertEquals((String)attr.getNameFormat(), (String)ATTR_NAMEFORMAT);
        Assert.assertEquals((String)attr.getFriendlyName(), (String)ATTR_FRIENDLYNAME);
        List children = attr.getOrderedChildren();
        Assert.assertEquals((int)children.size(), (int)1, (String)"Encoding one entry");
        Assert.assertEquals((Object)((XMLObject)children.get(0)).getElementQName(), (Object)AttributeValue.DEFAULT_ELEMENT_NAME, (String)"Attribute Value not inside <AttributeValue/>");
        Assert.assertEquals((int)((XMLObject)children.get(0)).getOrderedChildren().size(), (int)1, (String)"Expected exactly one child inside the <AttributeValue/>");
        SAML2XMLObjectAttributeTranscoderTest.checkValues((XMLObject)((XMLObject)children.get(0)).getOrderedChildren().get(0), STRING_1);
    }

    @Test
    public void singleRequested() throws Exception {
        List<XMLObjectAttributeValue> values = List.of(new ByteAttributeValue(new byte[]{1, 2, 3}), SAML2XMLObjectAttributeTranscoderTest.objectFor(STRING_1));
        IdPRequestedAttribute inputAttribute = new IdPRequestedAttribute(ATTR_NAME);
        inputAttribute.setRequired(true);
        inputAttribute.setValues(values);
        Collection rulesets = this.registry.getTranscodingRules((IdPAttribute)inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        RequestedAttribute attr = (RequestedAttribute)TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, (IdPAttribute)inputAttribute, RequestedAttribute.class, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getName(), (String)ATTR_NAME);
        Assert.assertEquals((String)attr.getNameFormat(), (String)ATTR_NAMEFORMAT);
        Assert.assertEquals((String)attr.getFriendlyName(), (String)ATTR_FRIENDLYNAME);
        Assert.assertTrue((boolean)attr.isRequired());
        List children = attr.getOrderedChildren();
        Assert.assertEquals((int)children.size(), (int)1, (String)"Encoding one entry");
        Assert.assertEquals((Object)((XMLObject)children.get(0)).getElementQName(), (Object)AttributeValue.DEFAULT_ELEMENT_NAME, (String)"Attribute Value not inside <AttributeValue/>");
        Assert.assertEquals((int)((XMLObject)children.get(0)).getOrderedChildren().size(), (int)1, (String)"Expected exactly one child inside the <AttributeValue/>");
        SAML2XMLObjectAttributeTranscoderTest.checkValues((XMLObject)((XMLObject)children.get(0)).getOrderedChildren().get(0), STRING_1);
    }

    @Test
    public void singleDecode() throws Exception {
        XSString stringValue = (XSString)this.stringBuilder.buildObject(new QName("Foo"));
        stringValue.setValue(STRING_1);
        AttributeValue attrValue = (AttributeValue)this.anyBuilder.buildObject();
        attrValue.getUnknownXMLObjects().add(stringValue);
        Attribute samlAttribute = (Attribute)this.attributeBuilder.buildObject();
        samlAttribute.setName(ATTR_NAME);
        samlAttribute.setNameFormat(ATTR_NAMEFORMAT);
        samlAttribute.getAttributeValues().add(attrValue);
        Collection rulesets = this.registry.getTranscodingRules((Object)samlAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)samlAttribute, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getId(), (String)ATTR_NAME);
        Assert.assertEquals((int)attr.getValues().size(), (int)1);
        XMLObjectAttributeValue value = (XMLObjectAttributeValue)attr.getValues().get(0);
        Assert.assertTrue((boolean)(value.getValue() instanceof XSString));
        Assert.assertEquals((String)value.getValue().getElementQName().getLocalPart(), (String)"Foo");
        Assert.assertEquals((String)((XSString)value.getValue()).getValue(), (String)STRING_1);
    }

    @Test
    public void singleRequestedDecode() throws Exception {
        XSString stringValue = (XSString)this.stringBuilder.buildObject(new QName("Foo"));
        stringValue.setValue(STRING_1);
        AttributeValue attrValue = (AttributeValue)this.anyBuilder.buildObject();
        attrValue.getUnknownXMLObjects().add(stringValue);
        RequestedAttribute samlAttribute = (RequestedAttribute)this.reqAttributeBuilder.buildObject();
        samlAttribute.setName(ATTR_NAME);
        samlAttribute.setNameFormat(ATTR_NAMEFORMAT);
        samlAttribute.setIsRequired(Boolean.valueOf(true));
        samlAttribute.getAttributeValues().add(attrValue);
        Collection rulesets = this.registry.getTranscodingRules((Object)samlAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)samlAttribute, ruleset);
        Assert.assertTrue((boolean)(attr instanceof IdPRequestedAttribute));
        Assert.assertEquals((String)attr.getId(), (String)ATTR_NAME);
        Assert.assertTrue((boolean)((IdPRequestedAttribute)attr).isRequired());
        Assert.assertEquals((int)attr.getValues().size(), (int)1);
        XMLObjectAttributeValue value = (XMLObjectAttributeValue)attr.getValues().get(0);
        Assert.assertTrue((boolean)(value.getValue() instanceof XSString));
        Assert.assertEquals((String)((XSString)value.getValue()).getValue(), (String)STRING_1);
    }

    @Test
    public void multi() throws Exception {
        List<XMLObjectAttributeValue> values = List.of(SAML2XMLObjectAttributeTranscoderTest.objectFor(STRING_1), SAML2XMLObjectAttributeTranscoderTest.objectFor(STRING_2));
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_NAME);
        inputAttribute.setValues(values);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        Attribute attr = (Attribute)TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, Attribute.class, ruleset);
        Assert.assertNotNull((Object)attr);
        List children = attr.getOrderedChildren();
        Assert.assertEquals((int)children.size(), (int)2, (String)"Encoding two entries");
        Assert.assertEquals((Object)((XMLObject)children.get(0)).getElementQName(), (Object)AttributeValue.DEFAULT_ELEMENT_NAME, (String)"Attribute Value not inside <AttributeValue/>");
        Assert.assertEquals((int)((XMLObject)children.get(0)).getOrderedChildren().size(), (int)1, (String)"Expected exactly one child inside the <AttributeValue/> for first Attribute");
        Assert.assertEquals((Object)((XMLObject)children.get(1)).getElementQName(), (Object)AttributeValue.DEFAULT_ELEMENT_NAME, (String)"Attribute Value not inside <AttributeValue/>");
        Assert.assertEquals((int)((XMLObject)children.get(1)).getOrderedChildren().size(), (int)1, (String)"Expected exactly one child inside the <AttributeValue/> for second Attribute");
        SAML2XMLObjectAttributeTranscoderTest.checkValues((XMLObject)((XMLObject)children.get(0)).getOrderedChildren().get(0), STRING_1, STRING_2);
        SAML2XMLObjectAttributeTranscoderTest.checkValues((XMLObject)((XMLObject)children.get(1)).getOrderedChildren().get(0), STRING_1, STRING_2);
    }

    @Test
    public void multiDecode() throws Exception {
        XSString stringValue = (XSString)this.stringBuilder.buildObject(new QName("Foo"));
        stringValue.setValue(STRING_1);
        AttributeValue attrValue = (AttributeValue)this.anyBuilder.buildObject();
        attrValue.getUnknownXMLObjects().add(stringValue);
        XSString stringValue2 = (XSString)this.stringBuilder.buildObject(new QName("Bar"));
        stringValue2.setValue(STRING_2);
        AttributeValue attrValue2 = (AttributeValue)this.anyBuilder.buildObject();
        attrValue2.getUnknownXMLObjects().add(stringValue2);
        Attribute samlAttribute = (Attribute)this.attributeBuilder.buildObject();
        samlAttribute.setName(ATTR_NAME);
        samlAttribute.setNameFormat(ATTR_NAMEFORMAT);
        samlAttribute.getAttributeValues().add(attrValue);
        samlAttribute.getAttributeValues().add(attrValue2);
        Collection rulesets = this.registry.getTranscodingRules((Object)samlAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)samlAttribute, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getId(), (String)ATTR_NAME);
        Assert.assertEquals((int)attr.getValues().size(), (int)2);
        XMLObjectAttributeValue value = (XMLObjectAttributeValue)attr.getValues().get(0);
        Assert.assertTrue((boolean)(value.getValue() instanceof XSString));
        XMLObjectAttributeValue value2 = (XMLObjectAttributeValue)attr.getValues().get(1);
        Assert.assertTrue((boolean)(value2.getValue() instanceof XSString));
        String s1 = ((XSString)value.getValue()).getValue();
        String s2 = ((XSString)value2.getValue()).getValue();
        Assert.assertTrue((STRING_1.equals(s1) || STRING_2.equals(s1) ? 1 : 0) != 0);
        Assert.assertTrue((STRING_1.equals(s2) || STRING_2.equals(s2) ? 1 : 0) != 0);
    }

    private static XMLObjectAttributeValue objectFor(String value) {
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_NAME);
        inputAttribute.setValues(Collections.singletonList(new StringAttributeValue(value)));
        return new XMLObjectAttributeValue(SAMLEncoderSupport.encodeStringValue((IdPAttribute)inputAttribute, (QName)new QName("Foo"), (String)value, (boolean)true));
    }

    private static void checkValues(XMLObject input, String ... possibles) {
        Assert.assertTrue((boolean)(input instanceof XSString));
        String s = ((XSString)input).getValue();
        for (String possible : possibles) {
            if (!s.equals(possible)) continue;
            return;
        }
        Assert.assertTrue((boolean)false, (String)"No potential match");
    }
}

