/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.metadata.impl;

import java.util.List;
import java.util.Locale;
import net.shibboleth.idp.saml.metadata.ACSUIInfo;
import net.shibboleth.idp.saml.metadata.IdPUIInfo;
import net.shibboleth.idp.saml.metadata.OrganizationUIInfo;
import net.shibboleth.idp.saml.metadata.impl.BaseNodeProcessorTest;
import net.shibboleth.idp.saml.metadata.impl.UIInfoNodeProcessor;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.ext.saml2mdui.UIInfo;
import org.opensaml.saml.metadata.resolver.filter.MetadataNodeProcessor;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.testng.Assert;
import org.testng.annotations.Test;

public final class UIInfoNodeProcessorTest
extends BaseNodeProcessorTest {
    @Test
    public void idPUIInfoTest() throws ResolverException {
        EntityDescriptor entity = (EntityDescriptor)this.resolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new EntityIdCriterion("https://scopes.example.org")}));
        IDPSSODescriptor idpSSO = entity.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        IdPUIInfo uiInfo = null;
        for (XMLObject x : idpSSO.getExtensions().getUnknownXMLObjects()) {
            if (!(x instanceof UIInfo)) continue;
            uiInfo = (IdPUIInfo)x.getObjectMetadata().get(IdPUIInfo.class).get(0);
            break;
        }
        Locale l = Locale.forLanguageTag("en");
        Assert.assertEquals((String)((String)uiInfo.getDisplayNames().get(l)), (String)"Display");
        Assert.assertEquals((String)((String)uiInfo.getDescriptions().get(l)), (String)"Desc");
        Assert.assertEquals((int)((List)uiInfo.getLocaleLogos().get(l)).size(), (int)1);
        Assert.assertEquals((int)uiInfo.getNonLocaleLogos().size(), (int)2);
    }

    public void acsUIInfoTest() throws ResolverException {
        EntityDescriptor entity = (EntityDescriptor)this.resolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new EntityIdCriterion("https://sp.example.org")}));
        AssertionConsumerService acs = (AssertionConsumerService)entity.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol").getAssertionConsumerServices().get(0);
        ACSUIInfo uiInfo = (ACSUIInfo)acs.getObjectMetadata().get(ACSUIInfo.class).get(0);
        Locale l = Locale.forLanguageTag("en");
        Assert.assertEquals((String)((String)uiInfo.getServiceNames().get(l)), (String)"ServiceName");
        Assert.assertEquals((String)((String)uiInfo.getServiceDescriptions().get(l)), (String)"ServiceDesc");
    }

    public void organizationInfoTest() throws ResolverException {
        EntityDescriptor entity = (EntityDescriptor)this.resolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new EntityIdCriterion("https://sp.example.org")}));
        OrganizationUIInfo info = (OrganizationUIInfo)entity.getOrganization().getObjectMetadata().get(OrganizationUIInfo.class).get(0);
        Assert.assertEquals((int)info.getOrganizationNames().size(), (int)2);
        Assert.assertEquals((String)((String)info.getOrganizationNames().get(Locale.forLanguageTag("en"))), (String)"org");
        Assert.assertEquals((int)info.getOrganizationDisplayNames().size(), (int)1);
        Assert.assertEquals((int)info.getOrganizationUrls().size(), (int)1);
    }

    @Override
    protected MetadataNodeProcessor getProcessor() {
        return new UIInfoNodeProcessor();
    }
}

