/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import java.io.IOException;
import java.security.Principal;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import javax.security.auth.Subject;
import net.shibboleth.ext.spring.resource.ResourceHelper;
import net.shibboleth.idp.authn.SubjectCanonicalizationException;
import net.shibboleth.idp.authn.SubjectCanonicalizationFlowDescriptor;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.authn.principal.NameIDPrincipal;
import net.shibboleth.idp.saml.nameid.NameDecoderException;
import net.shibboleth.idp.saml.nameid.NameIDCanonicalizationFlowDescriptor;
import net.shibboleth.idp.saml.nameid.NameIDDecoder;
import net.shibboleth.idp.saml.nameid.impl.CryptoTransientIdGenerationStrategy;
import net.shibboleth.idp.saml.nameid.impl.CryptoTransientNameIDDecoder;
import net.shibboleth.idp.saml.nameid.impl.NameIDCanonicalization;
import net.shibboleth.idp.saml.nameid.impl.TransientIdGenerationStrategy;
import net.shibboleth.idp.saml.nameid.impl.TransientSAML2NameIDGenerator;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import net.shibboleth.utilities.java.support.security.DataSealerKeyStrategy;
import net.shibboleth.utilities.java.support.security.impl.BasicKeystoreKeyStrategy;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.opensaml.saml.saml2.core.NameID;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CryptoTransientNameIDDecoderTest
extends OpenSAMLInitBaseTestCase {
    private static final Duration TIMEOUT = Duration.ofSeconds(5L);
    private static final String PRINCIPAL = "ThePrincipal";
    private static final String ISSUER = "https://idp.example.org/issuer";
    private static final String RECIPIENT = "https://sp.example.org/recipient";
    private DataSealer dataSealer;
    private CryptoTransientNameIDDecoder decoder;

    @BeforeClass
    public void setupDataSealer() throws IOException, DataSealerException, ComponentInitializationException {
        ClassPathResource keyStore = new ClassPathResource("/net/shibboleth/idp/saml/impl/attribute/resolver/SealerKeyStore.jks");
        Assert.assertTrue((boolean)keyStore.exists());
        ClassPathResource version = new ClassPathResource("/net/shibboleth/idp/saml/impl/attribute/resolver/SealerKeyStore.kver");
        Assert.assertTrue((boolean)version.exists());
        BasicKeystoreKeyStrategy kstrategy = new BasicKeystoreKeyStrategy();
        kstrategy.setKeyAlias("secret");
        kstrategy.setKeyPassword("kpassword");
        kstrategy.setKeystorePassword("password");
        kstrategy.setKeystoreResource(ResourceHelper.of((Resource)keyStore));
        kstrategy.setKeyVersionResource(ResourceHelper.of((Resource)version));
        kstrategy.initialize();
        this.dataSealer = new DataSealer();
        this.dataSealer.setKeyStrategy((DataSealerKeyStrategy)kstrategy);
        this.dataSealer.initialize();
        this.decoder = new CryptoTransientNameIDDecoder();
        this.decoder.setDataSealer(this.dataSealer);
        this.decoder.setId("Decoder");
        this.decoder.initialize();
    }

    private String code(String principalName, String attributeRecipientID, Duration timeout) throws DataSealerException {
        String principalTokenId = attributeRecipientID + "!" + principalName;
        return this.dataSealer.wrap(principalTokenId, Instant.now().plus(timeout));
    }

    private String code(String principalName, String attributeIssuerID, String attributeRecipientID) throws DataSealerException {
        return this.code(principalName, attributeRecipientID, TIMEOUT);
    }

    @Test
    public void testSucess() throws Exception {
        String ct = this.code(PRINCIPAL, ISSUER, RECIPIENT);
        Assert.assertEquals((String)this.decoder.decode(ct, RECIPIENT), (String)PRINCIPAL);
    }

    @Test(expectedExceptions={NameDecoderException.class})
    public void timeout() throws SubjectCanonicalizationException, DataSealerException, NameDecoderException {
        String ct = this.code(PRINCIPAL, RECIPIENT, Duration.ofMillis(-5L));
        this.decoder.decode(ct, RECIPIENT);
    }

    @Test(expectedExceptions={NameDecoderException.class})
    public void baddata() throws DataSealerException, NameDecoderException {
        String ct = this.code(PRINCIPAL, ISSUER, RECIPIENT);
        this.decoder.decode(ct.toUpperCase(), RECIPIENT);
    }

    @Test
    public void baddata2() throws DataSealerException, NameDecoderException {
        String principalTokenId = ISSUER + "!" + RECIPIENT + "+" + PRINCIPAL;
        String ct = this.dataSealer.wrap(principalTokenId, Instant.now().plus(TIMEOUT));
        Assert.assertNull((Object)this.decoder.decode(ct, RECIPIENT));
    }

    @Test
    public void badSP() throws DataSealerException, NameDecoderException {
        String ct = this.code(PRINCIPAL, ISSUER, RECIPIENT);
        Assert.assertNull((Object)this.decoder.decode(ct, "myhttps://sp.example.org/recipient"));
    }

    @Test
    public void decode() throws Exception {
        CryptoTransientIdGenerationStrategy strategy = new CryptoTransientIdGenerationStrategy();
        strategy.setDataSealer(this.dataSealer);
        strategy.setId("strategy");
        strategy.setIdLifetime(TIMEOUT);
        strategy.initialize();
        TransientSAML2NameIDGenerator generator = new TransientSAML2NameIDGenerator();
        generator.setId("id");
        generator.setTransientIdGenerator((TransientIdGenerationStrategy)strategy);
        generator.initialize();
        ProfileRequestContext prc = new RequestContextBuilder().setInboundMessageIssuer("https://sp.example.org/sp").buildProfileRequestContext();
        ((SubjectContext)prc.getSubcontext(SubjectContext.class, true)).setPrincipalName("PETER_THE_PRINCIPAL");
        NameID nameID = (NameID)generator.generate(prc, generator.getFormat());
        NameIDCanonicalizationFlowDescriptor desc = new NameIDCanonicalizationFlowDescriptor();
        desc.setId("C14NDesc");
        desc.setFormats(Collections.singleton(generator.getFormat()));
        desc.initialize();
        NameIDCanonicalization canon = new NameIDCanonicalization();
        canon.setDecoder((NameIDDecoder)this.decoder);
        canon.initialize();
        prc = new ProfileRequestContext();
        SubjectCanonicalizationContext scc = (SubjectCanonicalizationContext)prc.getSubcontext(SubjectCanonicalizationContext.class, true);
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new NameIDPrincipal(nameID));
        scc.setSubject(subject);
        scc.setAttemptedFlow((SubjectCanonicalizationFlowDescriptor)desc);
        scc.setRequesterId("https://sp.example.org/sp");
        scc.setResponderId("https://idp.example.org/idp");
        canon.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertEquals((String)scc.getPrincipalName(), (String)"PETER_THE_PRINCIPAL");
    }
}

