/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.nameid.impl.StoredTransientIdGenerationStrategy;
import net.shibboleth.idp.saml.nameid.impl.TransientIdGenerationStrategy;
import net.shibboleth.idp.saml.nameid.impl.TransientIdParameters;
import net.shibboleth.idp.saml.nameid.impl.TransientSAML2NameIDGenerator;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.impl.MemoryStorageService;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class StoredTransientSAML2NameIDGeneratorTest
extends OpenSAMLInitBaseTestCase {
    private MemoryStorageService store;
    private StoredTransientIdGenerationStrategy transientGenerator;
    private TransientSAML2NameIDGenerator generator;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.store = new MemoryStorageService();
        this.store.setId("test");
        this.store.initialize();
        this.transientGenerator = new StoredTransientIdGenerationStrategy();
        this.transientGenerator.setId("test");
        this.transientGenerator.setIdStore((StorageService)this.store);
        this.transientGenerator.initialize();
        this.generator = new TransientSAML2NameIDGenerator();
        this.generator.setId("test");
        this.generator.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        this.generator.setTransientIdGenerator((TransientIdGenerationStrategy)this.transientGenerator);
        this.generator.initialize();
    }

    @AfterMethod
    public void tearDown() {
        this.store.destroy();
        this.transientGenerator.destroy();
        this.generator.destroy();
    }

    @Test
    public void testNoPrincipal() throws Exception {
        ProfileRequestContext prc = new RequestContextBuilder().buildProfileRequestContext();
        NameID name = (NameID)this.generator.generate(prc, this.generator.getFormat());
        Assert.assertNull((Object)name);
    }

    @Test
    public void testNoRelyingParty() throws Exception {
        ProfileRequestContext prc = new RequestContextBuilder().buildProfileRequestContext();
        ((RelyingPartyContext)prc.getSubcontext(RelyingPartyContext.class)).setRelyingPartyId(null);
        ((SubjectContext)prc.getSubcontext(SubjectContext.class, true)).setPrincipalName("jdoe");
        NameID name = (NameID)this.generator.generate(prc, this.generator.getFormat());
        Assert.assertNull((Object)name);
    }

    @Test
    public void testTransient() throws Exception {
        ProfileRequestContext prc = new RequestContextBuilder().buildProfileRequestContext();
        RelyingPartyContext rpc = (RelyingPartyContext)prc.getSubcontext(RelyingPartyContext.class);
        ((SubjectContext)prc.getSubcontext(SubjectContext.class, true)).setPrincipalName("jdoe");
        NameID name = (NameID)this.generator.generate(prc, this.generator.getFormat());
        Assert.assertNotNull((Object)name);
        Assert.assertEquals((String)name.getFormat(), (String)this.generator.getFormat());
        Assert.assertEquals((String)name.getNameQualifier(), (String)rpc.getConfiguration().getResponderId(prc));
        Assert.assertEquals((String)name.getSPNameQualifier(), (String)rpc.getRelyingPartyId());
        String val = name.getValue();
        StorageRecord record = this.store.read("TransientId", val);
        Assert.assertNotNull((Object)record);
        Assert.assertTrue((val.length() >= this.transientGenerator.getIdSize() ? 1 : 0) != 0);
        TransientIdParameters parms = new TransientIdParameters(record.getValue());
        Assert.assertNotNull((Object)parms);
        Assert.assertEquals((String)parms.getAttributeRecipient(), (String)rpc.getRelyingPartyId());
        Assert.assertEquals((String)parms.getPrincipal(), (String)"jdoe");
    }
}

