/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import java.util.Arrays;
import java.util.Collections;
import net.shibboleth.idp.saml.nameid.impl.BaseTransformingDecoder;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.component.UninitializedComponentException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TransformingDecoderTest {
    private static final String PRINCIPAL = "ThePrincipalName@foo.edu";

    @Test(expectedExceptions={UninitializedComponentException.class})
    public void testNoinit() throws Exception {
        MockTransformingDecoder decode = new MockTransformingDecoder();
        decode.setId("Decoder");
        decode.decode(PRINCIPAL);
    }

    @Test
    public void testEcho() throws Exception {
        MockTransformingDecoder decode = new MockTransformingDecoder();
        decode.setId("Decoder");
        decode.initialize();
        Assert.assertEquals((String)decode.decode(PRINCIPAL), (String)PRINCIPAL);
    }

    @Test
    public void testStrip() throws Exception {
        MockTransformingDecoder decode = new MockTransformingDecoder();
        decode.setId("Decoder");
        decode.setTransforms(Collections.singletonList(new Pair((Object)"(.+)@foo.edu", (Object)"$1")));
        decode.initialize();
        Assert.assertEquals((String)decode.decode(PRINCIPAL), (String)"ThePrincipalName");
    }

    @Test
    public void testStripAndExtract() throws Exception {
        MockTransformingDecoder decode = new MockTransformingDecoder();
        decode.setId("Decoder");
        decode.setTransforms(Arrays.asList(new Pair((Object)"(.+)@foo.edu", (Object)"$1"), new Pair((Object)"([A-Z][a-z]+)([A-Z][a-z]+)([A-Z][a-z]+)", (Object)"$2")));
        decode.initialize();
        Assert.assertEquals((String)decode.decode(PRINCIPAL), (String)"Principal");
    }

    private class MockTransformingDecoder
    extends BaseTransformingDecoder {
        private MockTransformingDecoder() {
        }
    }
}

