/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.profile.impl.FinalizeSAMLSubjectCanonicalization;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FinalizeSAMLSubjectCanonicalizationTest {
    private RequestContext rc;
    private ProfileRequestContext prc;
    private FinalizeSAMLSubjectCanonicalization action;

    @BeforeMethod
    public void setUp() throws Exception {
        this.rc = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.rc);
        this.action = new FinalizeSAMLSubjectCanonicalization();
        this.action.initialize();
    }

    @Test
    public void testNoContext() {
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidSubjectCanonicalizationContext");
        Assert.assertNull((Object)this.prc.getSubcontext(SubjectContext.class));
    }

    @Test
    public void testNoPrincipal() {
        this.prc.getSubcontext(SubjectCanonicalizationContext.class, true);
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidSubjectCanonicalizationContext");
        Assert.assertNull((Object)this.prc.getSubcontext(SubjectContext.class));
    }

    @Test
    public void testMatch() {
        ((SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class, true)).setPrincipalName("foo");
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        SubjectContext sc = (SubjectContext)this.prc.getSubcontext(SubjectContext.class);
        Assert.assertNotNull((Object)sc);
        Assert.assertEquals((String)sc.getPrincipalName(), (String)"foo");
    }
}

