/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.profile.impl.InitializeOutboundMessageContextForError;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.binding.BindingDescriptor;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml1.core.Request;
import org.opensaml.saml.saml1.core.Subject;
import org.opensaml.saml.saml1.testing.SAML1ActionTestingSupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class InitializeOutboundMessageContextForErrorTest
extends OpenSAMLInitBaseTestCase {
    private RequestContext src;
    private ProfileRequestContext prc;
    private Request attributeQuery;
    private InitializeOutboundMessageContextForError action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.attributeQuery = SAML1ActionTestingSupport.buildAttributeQueryRequest((Subject)SAML1ActionTestingSupport.buildSubject((String)"jdoe"));
        this.src = new RequestContextBuilder().setInboundMessage((Object)this.attributeQuery).buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        this.prc.setOutboundMessageContext(null);
        this.action = new InitializeOutboundMessageContextForError();
        net.shibboleth.idp.saml.binding.BindingDescriptor bd = new net.shibboleth.idp.saml.binding.BindingDescriptor();
        bd.setId("urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding");
        bd.initialize();
        this.action.setOutboundBinding((BindingDescriptor)bd);
        this.action.initialize();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testBadConfig() throws ComponentInitializationException {
        InitializeOutboundMessageContextForError a = new InitializeOutboundMessageContextForError();
        a.initialize();
    }

    @Test
    public void testWithOutboundContext() {
        this.prc.setOutboundMessageContext(new MessageContext());
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testNoRelyingPartyContext() {
        this.prc.removeSubcontext(RelyingPartyContext.class);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.prc.getOutboundMessageContext());
        SAMLBindingContext bindingCtx = (SAMLBindingContext)this.prc.getOutboundMessageContext().getSubcontext(SAMLBindingContext.class);
        Assert.assertNotNull((Object)bindingCtx);
        Assert.assertEquals((String)bindingCtx.getBindingUri(), (String)"urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding");
        Assert.assertNull((Object)this.prc.getOutboundMessageContext().getSubcontext(SAMLPeerEntityContext.class));
    }

    @Test
    public void testNoPeerEntityContext() {
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.prc.getOutboundMessageContext());
        SAMLBindingContext bindingCtx = (SAMLBindingContext)this.prc.getOutboundMessageContext().getSubcontext(SAMLBindingContext.class);
        Assert.assertNotNull((Object)bindingCtx);
        Assert.assertEquals((String)bindingCtx.getBindingUri(), (String)"urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding");
        Assert.assertNull((Object)this.prc.getOutboundMessageContext().getSubcontext(SAMLPeerEntityContext.class));
    }

    @Test
    public void testPeerEntityContextNoIssuer() {
        SAMLPeerEntityContext ctx = (SAMLPeerEntityContext)this.prc.getInboundMessageContext().getSubcontext(SAMLPeerEntityContext.class, true);
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).setRelyingPartyIdContextTree((BaseContext)ctx);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.prc.getOutboundMessageContext());
        SAMLBindingContext bindingCtx = (SAMLBindingContext)this.prc.getOutboundMessageContext().getSubcontext(SAMLBindingContext.class);
        Assert.assertNotNull((Object)bindingCtx);
        Assert.assertEquals((String)bindingCtx.getBindingUri(), (String)"urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding");
        ctx = (SAMLPeerEntityContext)this.prc.getOutboundMessageContext().getSubcontext(SAMLPeerEntityContext.class);
        Assert.assertNotNull((Object)ctx);
        Assert.assertNull((Object)ctx.getEntityId());
    }

    @Test
    public void testPeerEntityContextIssuer() {
        SAMLPeerEntityContext ctx = (SAMLPeerEntityContext)this.prc.getInboundMessageContext().getSubcontext(SAMLPeerEntityContext.class, true);
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).setRelyingPartyIdContextTree((BaseContext)ctx);
        this.attributeQuery.getAttributeQuery().setResource("issuer");
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.prc.getOutboundMessageContext());
        SAMLBindingContext bindingCtx = (SAMLBindingContext)this.prc.getOutboundMessageContext().getSubcontext(SAMLBindingContext.class);
        Assert.assertNotNull((Object)bindingCtx);
        Assert.assertEquals((String)bindingCtx.getBindingUri(), (String)"urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding");
        ctx = (SAMLPeerEntityContext)this.prc.getOutboundMessageContext().getSubcontext(SAMLPeerEntityContext.class);
        Assert.assertNotNull((Object)ctx);
        Assert.assertEquals((String)ctx.getEntityId(), (String)"issuer");
    }
}

