/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml1.profile.impl;

import java.security.Principal;
import java.time.Instant;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.authn.impl.DefaultAuthenticationResultSerializer;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.authn.principal.AuthenticationMethodPrincipal;
import net.shibboleth.idp.saml.saml1.profile.SAML1ActionTestingSupport;
import net.shibboleth.idp.saml.saml1.profile.impl.AddAuthenticationStatementToAssertion;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.AuthenticationStatement;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.storage.StorageSerializer;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddAuthenticationStatementToAssertionTest
extends OpenSAMLInitBaseTestCase {
    private RequestContext rc;
    private ProfileRequestContext prc;
    private AddAuthenticationStatementToAssertion action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.rc = new RequestContextBuilder().setOutboundMessage((Object)SAML1ActionTestingSupport.buildResponse()).buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.rc);
        this.action = new AddAuthenticationStatementToAssertion();
        this.action.setHttpServletRequest((HttpServletRequest)new MockHttpServletRequest());
        this.action.initialize();
    }

    @Test
    public void testNoAuthnContext() throws Exception {
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidAuthenticationContext");
    }

    @Test
    public void testNoRelyingPartyContext() throws Exception {
        this.prc.getSubcontext(AuthenticationContext.class, true);
        this.prc.removeSubcontext(RelyingPartyContext.class);
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidProfileContext");
    }

    @Test
    public void testNoContext() throws Exception {
        this.prc.setOutboundMessageContext(null);
        ((AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class, true)).setAuthenticationResult(new AuthenticationResult("Test", (Principal)new AuthenticationMethodPrincipal("Test")));
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidMessageContext");
    }

    @Test
    public void testNoAuthenticationStatement() throws Exception {
        this.prc.getSubcontext(AuthenticationContext.class, true);
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidAuthenticationContext");
    }

    @Test
    public void testAddAuthenticationStatement() throws Exception {
        Instant now = Instant.now();
        Thread.sleep(50L);
        DefaultAuthenticationResultSerializer serializer = new DefaultAuthenticationResultSerializer();
        serializer.initialize();
        AuthenticationFlowDescriptor fd = new AuthenticationFlowDescriptor();
        fd.setId("Test");
        fd.setResultSerializer((StorageSerializer)serializer);
        fd.initialize();
        ((AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class, true)).getAvailableFlows().put("Test", fd);
        ((AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class)).setAuthenticationResult(new AuthenticationResult("Test", (Principal)new AuthenticationMethodPrincipal("Test")));
        ((MockHttpServletRequest)this.action.getHttpServletRequest()).setRemoteAddr("127.0.0.1");
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.prc.getOutboundMessageContext().getMessage());
        Assert.assertTrue((boolean)(this.prc.getOutboundMessageContext().getMessage() instanceof Response));
        Response response = (Response)this.prc.getOutboundMessageContext().getMessage();
        Assert.assertEquals((int)response.getAssertions().size(), (int)1);
        Assert.assertNotNull(response.getAssertions().get(0));
        Assertion assertion = (Assertion)response.getAssertions().get(0);
        Assert.assertEquals((int)assertion.getAuthenticationStatements().size(), (int)1);
        Assert.assertNotNull(assertion.getAuthenticationStatements().get(0));
        AuthenticationStatement authenticationStatement = (AuthenticationStatement)assertion.getAuthenticationStatements().get(0);
        Assert.assertTrue((boolean)authenticationStatement.getAuthenticationInstant().isAfter(now));
        Assert.assertEquals((String)authenticationStatement.getAuthenticationMethod(), (String)"Test");
        Assert.assertNotNull((Object)authenticationStatement.getSubjectLocality());
        Assert.assertEquals((String)authenticationStatement.getSubjectLocality().getIPAddress(), (String)"127.0.0.1");
    }

    @Test
    public void testAddAuthenticationStatementAndMethod() throws Exception {
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new AuthenticationMethodPrincipal("Foo"));
        subject.getPrincipals().add((Principal)new AuthenticationMethodPrincipal("Bar"));
        ((AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class, true)).setAuthenticationResult(new AuthenticationResult("Test", subject));
        RequestedPrincipalContext requested = new RequestedPrincipalContext();
        requested.setMatchingPrincipal((Principal)new AuthenticationMethodPrincipal("Bar"));
        ((AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class, false)).addSubcontext((BaseContext)requested);
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.prc.getOutboundMessageContext().getMessage());
        Assert.assertTrue((boolean)(this.prc.getOutboundMessageContext().getMessage() instanceof Response));
        Response response = (Response)this.prc.getOutboundMessageContext().getMessage();
        Assert.assertEquals((int)response.getAssertions().size(), (int)1);
        Assert.assertNotNull(response.getAssertions().get(0));
        Assertion assertion = (Assertion)response.getAssertions().get(0);
        Assert.assertEquals((int)assertion.getAuthenticationStatements().size(), (int)1);
        Assert.assertNotNull(assertion.getAuthenticationStatements().get(0));
        AuthenticationStatement authenticationStatement = (AuthenticationStatement)assertion.getAuthenticationStatements().get(0);
        Assert.assertEquals((String)authenticationStatement.getAuthenticationMethod(), (String)"Bar");
    }
}

