/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml1.profile.impl;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.saml.profile.impl.IdPInitiatedSSORequest;
import net.shibboleth.idp.saml.saml1.profile.impl.IdPInitiatedSSORequestMessageDecoder;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.common.messaging.context.SAMLMessageInfoContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class IdPInitiatedSSORequestMessageDecoderTest {
    private IdPInitiatedSSORequestMessageDecoder decoder;
    private MockHttpServletRequest request;
    private String entityId = "http://sp.example.org";
    private String acsUrl = "http://sp.example.org/acs";
    private String relayState = "myRelayState";
    private String sessionID = "abc123";
    private String messageID;
    private Instant time;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.time = Instant.now();
        this.messageID = "_" + this.sessionID + "!" + Long.toUnsignedString(this.time.getEpochSecond());
        this.request = new MockHttpServletRequest();
        this.request.setRequestedSessionId(this.sessionID);
        this.decoder = new IdPInitiatedSSORequestMessageDecoder();
        this.decoder.setHttpServletRequest((HttpServletRequest)this.request);
        this.decoder.initialize();
    }

    @Test
    public void testDecoder() throws MessageDecodingException {
        this.request.addParameter("providerId", this.entityId);
        this.request.addParameter("shire", this.acsUrl);
        this.request.addParameter("target", this.relayState);
        this.request.addParameter("time", Long.toUnsignedString(this.time.getEpochSecond()));
        this.decoder.decode();
        MessageContext messageContext = this.decoder.getMessageContext();
        Assert.assertNotNull((Object)messageContext);
        IdPInitiatedSSORequest ssoRequest = (IdPInitiatedSSORequest)messageContext.getMessage();
        Assert.assertNotNull((Object)ssoRequest);
        Assert.assertEquals((String)ssoRequest.getEntityId(), (String)this.entityId, (String)"Incorrect decoded entityId value");
        Assert.assertEquals((String)ssoRequest.getAssertionConsumerServiceURL(), (String)this.acsUrl, (String)"Incorrect decoded ACS URL value");
        Assert.assertEquals((String)ssoRequest.getRelayState(), (String)this.relayState, (String)"Incorrect decoded relay state value");
        Assert.assertEquals((Object)ssoRequest.getTime(), (Object)this.time.truncatedTo(ChronoUnit.SECONDS), (String)"Incorrect decoded time value");
        Assert.assertEquals((String)((SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class, true)).getEntityId(), (String)this.entityId, (String)"Incorrect decoded entityId value in peer context");
        SAMLBindingContext bindingContext = (SAMLBindingContext)messageContext.getSubcontext(SAMLBindingContext.class, true);
        Assert.assertEquals((String)bindingContext.getRelayState(), (String)this.relayState, (String)"Incorrect decoded relay state value in binding context");
        Assert.assertEquals((String)bindingContext.getBindingUri(), (String)"urn:mace:shibboleth:1.0:profiles:AuthnRequest", (String)"Incorrect binding URI in binding context");
        SAMLMessageInfoContext msgInfoContext = (SAMLMessageInfoContext)messageContext.getSubcontext(SAMLMessageInfoContext.class, true);
        Assert.assertEquals((Object)msgInfoContext.getMessageIssueInstant(), (Object)this.time.truncatedTo(ChronoUnit.SECONDS), (String)"Incorrect decoded issue instant value in message info context");
        Assert.assertEquals((String)msgInfoContext.getMessageId(), (String)this.messageID, (String)"Incorrect decoded message ID value in message info context");
    }

    @Test(expectedExceptions={MessageDecodingException.class})
    public void testMissingTarget() throws MessageDecodingException {
        this.request.addParameter("providerId", this.entityId);
        this.request.addParameter("shire", this.acsUrl);
        this.request.addParameter("time", Long.toUnsignedString(this.time.getEpochSecond()));
        this.decoder.decode();
    }
}

