/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.delegation.impl;

import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.saml2.profile.SAML2ActionTestingSupport;
import net.shibboleth.idp.saml.saml2.profile.delegation.LibertySSOSContext;
import net.shibboleth.idp.saml.saml2.profile.delegation.impl.DelegatedAssertionLookupStrategy;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.Assertion;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DelegatedAssertionLookupStrategyTest
extends OpenSAMLInitBaseTestCase {
    private DelegatedAssertionLookupStrategy strategy;
    private ProfileRequestContext prc;
    private Assertion delegatedAssertion;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        RequestContext rc = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(rc);
        this.delegatedAssertion = SAML2ActionTestingSupport.buildAssertion();
        ((LibertySSOSContext)this.prc.getSubcontext(LibertySSOSContext.class, true)).setAttestedToken(this.delegatedAssertion);
        this.strategy = new DelegatedAssertionLookupStrategy();
    }

    @Test
    public void testSuccess() {
        Assertion assertion = this.strategy.apply(this.prc);
        Assert.assertNotNull((Object)assertion);
        Assert.assertSame((Object)assertion, (Object)this.delegatedAssertion);
    }

    @Test
    void testNoPRC() {
        Assertion assertion = this.strategy.apply(null);
        Assert.assertNull((Object)assertion);
    }

    @Test
    public void testNoLibertyContext() {
        this.prc.removeSubcontext(LibertySSOSContext.class);
        Assertion assertion = this.strategy.apply(this.prc);
        Assert.assertNull((Object)assertion);
    }

    @Test
    public void testNoAssertion() {
        ((LibertySSOSContext)this.prc.getSubcontext(LibertySSOSContext.class)).setAttestedToken(null);
        Assertion assertion = this.strategy.apply(this.prc);
        Assert.assertNull((Object)assertion);
    }
}

