/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.delegation.impl;

import com.google.common.base.Predicates;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.saml2.profile.SAML2ActionTestingSupport;
import net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.idp.saml.saml2.profile.delegation.DelegationContext;
import net.shibboleth.idp.saml.saml2.profile.delegation.DelegationRequest;
import net.shibboleth.idp.saml.saml2.profile.delegation.impl.PopulateDelegationContext;
import net.shibboleth.utilities.java.support.codec.EncodingException;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.UninitializedComponentException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.AttributeConsumingServiceContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AttributeQuery;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.RequestedAttribute;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.security.impl.MetadataCredentialResolver;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockServletContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PopulateDelegationContextTest
extends OpenSAMLInitBaseTestCase {
    private AuthnRequest authnRequest;
    private Response response;
    private Assertion assertion;
    private BrowserSSOProfileConfiguration browserSSOProfileConfig;
    private List<ProfileConfiguration> profileConfigs;
    private List<PublicKey> publicKeys = new ArrayList<PublicKey>();
    private int numKeys = 3;
    private SAMLPeerEntityContext samlPeerContext;
    private SAMLMetadataContext samlMetadataContext;
    private PopulateDelegationContext action;
    private MockServletContext servletContext;
    private MockHttpServletRequest servletRequest;
    private RequestContext rc;
    private ProfileRequestContext prc;

    public PopulateDelegationContextTest() throws NoSuchAlgorithmException, NoSuchProviderException {
        for (int i = 0; i < this.numKeys; ++i) {
            this.publicKeys.add(KeySupport.generateKeyPair((String)"RSA", (int)2048, null).getPublic());
        }
    }

    @BeforeMethod
    protected void setUp() throws ComponentInitializationException, EncodingException {
        this.servletContext = new MockServletContext();
        this.servletContext.setContextPath("/idp");
        this.servletRequest = new MockHttpServletRequest((ServletContext)this.servletContext);
        this.servletRequest.setScheme("https");
        this.servletRequest.setServerName("idp.example.org");
        this.servletRequest.setServerPort(443);
        this.servletRequest.setRequestURI("/idp/profile/SAML2/Redirect/SSO");
        this.servletRequest.setContextPath("/idp");
        this.authnRequest = SAML2ActionTestingSupport.buildAuthnRequest();
        this.authnRequest.setIssuer(SAML2ActionTestingSupport.buildIssuer((String)"http://sp.example.org"));
        this.response = SAML2ActionTestingSupport.buildResponse();
        this.response.setIssuer(SAML2ActionTestingSupport.buildIssuer((String)"http://idp.example.org"));
        this.assertion = SAML2ActionTestingSupport.buildAssertion();
        this.assertion.setID("assertion");
        this.assertion.setIssuer(SAML2ActionTestingSupport.buildIssuer((String)"http://idp.example.org"));
        this.assertion.setSubject(SAML2ActionTestingSupport.buildSubject((String)"morpheus"));
        this.assertion.getAuthnStatements().add(SAML2ActionTestingSupport.buildAuthnStatement());
        this.assertion.getAttributeStatements().add(SAML2ActionTestingSupport.buildAttributeStatement());
        this.response.getAssertions().add(this.assertion);
        this.browserSSOProfileConfig = new BrowserSSOProfileConfiguration();
        this.profileConfigs = new ArrayList<ProfileConfiguration>();
        this.profileConfigs.add((ProfileConfiguration)this.browserSSOProfileConfig);
        this.rc = new RequestContextBuilder().setServletContext((ServletContext)this.servletContext).setHttpRequest((HttpServletRequest)this.servletRequest).setInboundMessage((Object)this.authnRequest).setOutboundMessage((Object)this.response).setRelyingPartyProfileConfigurations(this.profileConfigs).buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.rc);
        RelyingPartyContext rpcContext = (RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class);
        this.samlPeerContext = (SAMLPeerEntityContext)rpcContext.getSubcontext(SAMLPeerEntityContext.class, true);
        this.samlPeerContext.setEntityId("http://sp.example.org");
        this.samlPeerContext.setRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        rpcContext.setRelyingPartyIdContextTree((BaseContext)this.samlPeerContext);
        this.samlMetadataContext = (SAMLMetadataContext)this.samlPeerContext.getSubcontext(SAMLMetadataContext.class, true);
        this.samlMetadataContext.setRoleDescriptor((RoleDescriptor)this.buildSPSSODescriptor());
        MetadataCredentialResolver mcr = new MetadataCredentialResolver();
        mcr.setKeyInfoCredentialResolver(DefaultSecurityConfigurationBootstrap.buildBasicInlineKeyInfoCredentialResolver());
        mcr.initialize();
        this.action = new PopulateDelegationContext();
        this.action.setCredentialResolver((CredentialResolver)mcr);
    }

    @Test(expectedExceptions={UninitializedComponentException.class})
    public void testNotInitialized() throws Exception {
        this.action.execute(this.rc);
        DelegationContext delegationContext = (DelegationContext)this.prc.getSubcontext(DelegationContext.class);
        Assert.assertNull((Object)delegationContext);
    }

    @Test
    public void testNoInboundMessageContext() throws Exception {
        this.prc.setInboundMessageContext(null);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"InvalidMessageContext");
        DelegationContext delegationContext = (DelegationContext)this.prc.getSubcontext(DelegationContext.class);
        Assert.assertNull((Object)delegationContext);
    }

    @Test
    public void testNoInboundMessage() throws Exception {
        this.prc.getInboundMessageContext().setMessage(null);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"InvalidMessageContext");
        DelegationContext delegationContext = (DelegationContext)this.prc.getSubcontext(DelegationContext.class);
        Assert.assertNull((Object)delegationContext);
    }

    @Test
    public void testInboundMessageNotSAML2AuthnRequest() throws Exception {
        this.prc.getInboundMessageContext().setMessage((Object)XMLObjectSupport.buildXMLObject((QName)AttributeQuery.DEFAULT_ELEMENT_NAME));
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        DelegationContext delegationContext = (DelegationContext)this.prc.getSubcontext(DelegationContext.class);
        Assert.assertNull((Object)delegationContext);
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testNoCredentialResolver() throws Exception {
        this.action = new PopulateDelegationContext();
        this.action.initialize();
        DelegationContext delegationContext = (DelegationContext)this.prc.getSubcontext(DelegationContext.class);
        Assert.assertNull((Object)delegationContext);
    }

    @Test
    public void testNoRelyingPartyContext() throws Exception {
        this.prc.removeSubcontext(RelyingPartyContext.class);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"InvalidProfileContext");
        DelegationContext delegationContext = (DelegationContext)this.prc.getSubcontext(DelegationContext.class);
        Assert.assertNull((Object)delegationContext);
    }

    @Test
    public void testActivationCondition() throws Exception {
        this.action.setActivationCondition((Predicate)Predicates.alwaysFalse());
        this.prc.clearSubcontexts();
        this.prc.setInboundMessageContext(null);
        this.prc.setOutboundMessageContext(null);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        DelegationContext delegationContext = (DelegationContext)this.prc.getSubcontext(DelegationContext.class);
        Assert.assertNull((Object)delegationContext);
    }

    @Test
    public void testNoMetadataContext() throws Exception {
        this.samlPeerContext.removeSubcontext(SAMLMetadataContext.class);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        DelegationContext delegationContext = (DelegationContext)this.prc.getSubcontext(DelegationContext.class);
        Assert.assertNull((Object)delegationContext);
    }

    @Test
    public void testNoRoleDescriptor() throws Exception {
        this.samlMetadataContext.setRoleDescriptor(null);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        DelegationContext delegationContext = (DelegationContext)this.prc.getSubcontext(DelegationContext.class);
        Assert.assertNull((Object)delegationContext);
    }

    @Test
    public void testDelegationNotRequested() throws Exception {
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        DelegationContext delegationContext = (DelegationContext)this.prc.getSubcontext(DelegationContext.class);
        Assert.assertNull((Object)delegationContext);
    }

    @Test
    public void testRequestedViaMetadataNotRequiredNotAllowed() throws Exception {
        ((AttributeConsumingServiceContext)this.samlMetadataContext.getSubcontext(AttributeConsumingServiceContext.class, true)).setAttributeConsumingService(this.buildDelegationRequestAttributeConsumingService(false));
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        DelegationContext delegationContext = (DelegationContext)this.prc.getSubcontext(DelegationContext.class);
        Assert.assertNull((Object)delegationContext);
    }

    @Test
    public void testRequestedViaMetadataRequiredNotAllowed() throws Exception {
        ((AttributeConsumingServiceContext)this.samlMetadataContext.getSubcontext(AttributeConsumingServiceContext.class, true)).setAttributeConsumingService(this.buildDelegationRequestAttributeConsumingService(true));
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"InvalidSecurityConfiguration");
        DelegationContext delegationContext = (DelegationContext)this.prc.getSubcontext(DelegationContext.class);
        Assert.assertNull((Object)delegationContext);
    }

    @Test
    public void testRequestedViaMetadataNotRequiredAllowed() throws Exception {
        ((AttributeConsumingServiceContext)this.samlMetadataContext.getSubcontext(AttributeConsumingServiceContext.class, true)).setAttributeConsumingService(this.buildDelegationRequestAttributeConsumingService(false));
        this.browserSSOProfileConfig.setAllowDelegation(true);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        DelegationContext delegationContext = (DelegationContext)this.prc.getSubcontext(DelegationContext.class);
        Assert.assertNotNull((Object)delegationContext);
        Assert.assertEquals((boolean)delegationContext.isIssuingDelegatedAssertion(), (boolean)true);
        Assert.assertEquals((Object)delegationContext.getDelegationRequested(), (Object)DelegationRequest.REQUESTED_OPTIONAL);
        Assert.assertNotNull((Object)delegationContext.getSubjectConfirmationCredentials());
        Assert.assertFalse((boolean)delegationContext.getSubjectConfirmationCredentials().isEmpty());
    }

    @Test
    public void testRequestedViaMetadataRequiredAllowed() throws Exception {
        ((AttributeConsumingServiceContext)this.samlMetadataContext.getSubcontext(AttributeConsumingServiceContext.class, true)).setAttributeConsumingService(this.buildDelegationRequestAttributeConsumingService(true));
        this.browserSSOProfileConfig.setAllowDelegation(true);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        DelegationContext delegationContext = (DelegationContext)this.prc.getSubcontext(DelegationContext.class);
        Assert.assertNotNull((Object)delegationContext);
        Assert.assertEquals((boolean)delegationContext.isIssuingDelegatedAssertion(), (boolean)true);
        Assert.assertEquals((Object)delegationContext.getDelegationRequested(), (Object)DelegationRequest.REQUESTED_REQUIRED);
        Assert.assertNotNull((Object)delegationContext.getSubjectConfirmationCredentials());
        Assert.assertFalse((boolean)delegationContext.getSubjectConfirmationCredentials().isEmpty());
    }

    @Test
    public void testRequestedViaConditionsNotAllowed() throws Exception {
        this.authnRequest.setConditions(this.buildDelegationRequestConditions());
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"InvalidSecurityConfiguration");
        DelegationContext delegationContext = (DelegationContext)this.prc.getSubcontext(DelegationContext.class);
        Assert.assertNull((Object)delegationContext);
    }

    @Test
    public void testRequestedViaConditionsAllowed() throws Exception {
        this.authnRequest.setConditions(this.buildDelegationRequestConditions());
        this.browserSSOProfileConfig.setAllowDelegation(true);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        DelegationContext delegationContext = (DelegationContext)this.prc.getSubcontext(DelegationContext.class);
        Assert.assertNotNull((Object)delegationContext);
        Assert.assertEquals((boolean)delegationContext.isIssuingDelegatedAssertion(), (boolean)true);
        Assert.assertEquals((Object)delegationContext.getDelegationRequested(), (Object)DelegationRequest.REQUESTED_REQUIRED);
        Assert.assertNotNull((Object)delegationContext.getSubjectConfirmationCredentials());
        Assert.assertFalse((boolean)delegationContext.getSubjectConfirmationCredentials().isEmpty());
    }

    @Test
    public void testRequiredNoKeyDescriptors() throws Exception {
        this.samlMetadataContext.getRoleDescriptor().getKeyDescriptors().clear();
        this.authnRequest.setConditions(this.buildDelegationRequestConditions());
        this.browserSSOProfileConfig.setAllowDelegation(true);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"MessageProcessingError");
        DelegationContext delegationContext = (DelegationContext)this.prc.getSubcontext(DelegationContext.class);
        Assert.assertNull((Object)delegationContext);
    }

    @Test
    public void testNotRequiredNoKeyDescriptors() throws Exception {
        this.samlMetadataContext.getRoleDescriptor().getKeyDescriptors().clear();
        ((AttributeConsumingServiceContext)this.samlMetadataContext.getSubcontext(AttributeConsumingServiceContext.class, true)).setAttributeConsumingService(this.buildDelegationRequestAttributeConsumingService(false));
        this.browserSSOProfileConfig.setAllowDelegation(true);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        DelegationContext delegationContext = (DelegationContext)this.prc.getSubcontext(DelegationContext.class);
        Assert.assertNull((Object)delegationContext);
    }

    private Conditions buildDelegationRequestConditions() {
        Audience audience = (Audience)XMLObjectSupport.buildXMLObject((QName)Audience.DEFAULT_ELEMENT_NAME);
        audience.setURI(((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getConfiguration().getResponderId(this.prc));
        AudienceRestriction ar = (AudienceRestriction)XMLObjectSupport.buildXMLObject((QName)AudienceRestriction.DEFAULT_ELEMENT_NAME);
        ar.getAudiences().add(audience);
        Conditions conditions = (Conditions)XMLObjectSupport.buildXMLObject((QName)Conditions.DEFAULT_ELEMENT_NAME);
        conditions.getAudienceRestrictions().add(ar);
        return conditions;
    }

    private AttributeConsumingService buildDelegationRequestAttributeConsumingService(boolean required) {
        RequestedAttribute ra = (RequestedAttribute)XMLObjectSupport.buildXMLObject((QName)RequestedAttribute.DEFAULT_ELEMENT_NAME);
        ra.setName("urn:liberty:ssos:2006-08");
        ra.setIsRequired(Boolean.valueOf(required));
        AttributeConsumingService acs = (AttributeConsumingService)XMLObjectSupport.buildXMLObject((QName)AttributeConsumingService.DEFAULT_ELEMENT_NAME);
        acs.getRequestedAttributes().add(ra);
        return acs;
    }

    private SPSSODescriptor buildSPSSODescriptor() throws EncodingException {
        SPSSODescriptor spSSODescriptor = (SPSSODescriptor)XMLObjectSupport.buildXMLObject((QName)SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        for (PublicKey publicKey : this.publicKeys) {
            KeyInfo keyInfo = (KeyInfo)XMLObjectSupport.buildXMLObject((QName)KeyInfo.DEFAULT_ELEMENT_NAME);
            KeyInfoSupport.addPublicKey((KeyInfo)keyInfo, (PublicKey)publicKey);
            KeyDescriptor keyDescriptor = (KeyDescriptor)XMLObjectSupport.buildXMLObject((QName)KeyDescriptor.DEFAULT_ELEMENT_NAME);
            keyDescriptor.setUse(UsageType.SIGNING);
            keyDescriptor.setKeyInfo(keyInfo);
            spSSODescriptor.getKeyDescriptors().add(keyDescriptor);
        }
        EntityDescriptor ed = (EntityDescriptor)XMLObjectSupport.buildXMLObject((QName)EntityDescriptor.DEFAULT_ELEMENT_NAME);
        ed.setEntityID("http://sp.example.org");
        ed.getRoleDescriptors().add(spSSODescriptor);
        return spSSODescriptor;
    }
}

