/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.delegation.impl;

import java.time.Instant;
import net.shibboleth.idp.saml.saml2.profile.delegation.impl.PopulateOutboundMessageContext;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.EventContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLMessageInfoContext;
import org.opensaml.soap.wsaddressing.messaging.WSAddressingContext;
import org.opensaml.soap.wssecurity.messaging.WSSecurityContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PopulateOutboundMessageContextTest {
    private PopulateOutboundMessageContext action;
    private ProfileRequestContext prc;

    @BeforeMethod
    public void setUp() {
        this.prc = new ProfileRequestContext();
        this.prc.setInboundMessageContext(new MessageContext());
        this.prc.setOutboundMessageContext(new MessageContext());
        this.action = new PopulateOutboundMessageContext();
    }

    @Test
    public void testBasic() throws ComponentInitializationException {
        Instant now = Instant.now();
        ((WSAddressingContext)this.prc.getInboundMessageContext().getSubcontext(WSAddressingContext.class, true)).setMessageIDURI("urn:test:abc123");
        ((SAMLMessageInfoContext)this.prc.getOutboundMessageContext().getSubcontext(SAMLMessageInfoContext.class, true)).setMessageIssueInstant(now);
        this.action.initialize();
        this.action.execute(this.prc);
        Assert.assertEquals((String)((WSAddressingContext)this.prc.getOutboundMessageContext().getSubcontext(WSAddressingContext.class, true)).getRelatesToURI(), (String)"urn:test:abc123");
        Assert.assertSame((Object)((WSSecurityContext)this.prc.getOutboundMessageContext().getSubcontext(WSSecurityContext.class, true)).getTimestampCreated(), (Object)now);
    }

    @Test
    public void testNoInboundMessageID() throws ComponentInitializationException {
        Instant now = Instant.now();
        ((SAMLMessageInfoContext)this.prc.getOutboundMessageContext().getSubcontext(SAMLMessageInfoContext.class, true)).setMessageIssueInstant(now);
        this.action.initialize();
        this.action.execute(this.prc);
        Assert.assertNull((Object)((WSAddressingContext)this.prc.getOutboundMessageContext().getSubcontext(WSAddressingContext.class, true)).getRelatesToURI());
        Assert.assertSame((Object)((WSSecurityContext)this.prc.getOutboundMessageContext().getSubcontext(WSSecurityContext.class, true)).getTimestampCreated(), (Object)now);
    }

    @Test
    public void testNoSAMLMessageInfoContext() throws ComponentInitializationException {
        ((WSAddressingContext)this.prc.getInboundMessageContext().getSubcontext(WSAddressingContext.class, true)).setMessageIDURI("urn:test:abc123");
        this.action.initialize();
        this.action.execute(this.prc);
        Assert.assertEquals((String)((WSAddressingContext)this.prc.getOutboundMessageContext().getSubcontext(WSAddressingContext.class, true)).getRelatesToURI(), (String)"urn:test:abc123");
        Assert.assertNotNull((Object)((WSSecurityContext)this.prc.getOutboundMessageContext().getSubcontext(WSSecurityContext.class, true)).getTimestampCreated());
    }

    @Test
    public void testNoInboundContext() throws ComponentInitializationException {
        this.prc.setInboundMessageContext(null);
        this.action.initialize();
        this.action.execute(this.prc);
        Assert.assertEquals((Object)((EventContext)this.prc.getSubcontext(EventContext.class)).getEvent(), (Object)"InvalidMessageContext");
    }

    @Test
    public void testNoOutboundContext() throws ComponentInitializationException {
        this.prc.setOutboundMessageContext(null);
        this.action.initialize();
        this.action.execute(this.prc);
        Assert.assertEquals((Object)((EventContext)this.prc.getSubcontext(EventContext.class)).getEvent(), (Object)"InvalidMessageContext");
    }
}

