/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.delegation.impl;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.authn.principal.NameIDPrincipal;
import net.shibboleth.idp.saml.idwsf.profile.config.SSOSProfileConfiguration;
import net.shibboleth.idp.saml.saml2.profile.SAML2ActionTestingSupport;
import net.shibboleth.idp.saml.saml2.profile.delegation.LibertySSOSContext;
import net.shibboleth.idp.saml.saml2.profile.delegation.impl.ProcessDelegatedAssertion;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLPresenterEntityContext;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Response;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ProcessDelegatedAssertionTest
extends OpenSAMLInitBaseTestCase {
    private ProcessDelegatedAssertion action;
    private RequestContext rc;
    private ProfileRequestContext prc;
    private SSOSProfileConfiguration ssosProfileConfig;
    private List<ProfileConfiguration> profileConfigs;
    private Assertion delegatedAssertion;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        Response response = SAML2ActionTestingSupport.buildResponse();
        response.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        this.ssosProfileConfig = new SSOSProfileConfiguration();
        this.ssosProfileConfig.setDelegationPredicate((Predicate)Predicates.alwaysTrue());
        this.profileConfigs = new ArrayList<ProfileConfiguration>();
        this.profileConfigs.add((ProfileConfiguration)this.ssosProfileConfig);
        this.rc = new RequestContextBuilder().setInboundMessage((Object)SAML2ActionTestingSupport.buildAuthnRequest()).setOutboundMessage((Object)response).setRelyingPartyProfileConfigurations(this.profileConfigs).buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.rc);
        this.delegatedAssertion = SAML2ActionTestingSupport.buildAssertion();
        this.delegatedAssertion.setSubject(SAML2ActionTestingSupport.buildSubject((String)"morpheus"));
        ((LibertySSOSContext)this.prc.getSubcontext(LibertySSOSContext.class, true)).setAttestedToken(this.delegatedAssertion);
        this.action = new ProcessDelegatedAssertion();
    }

    @Test
    public void testSuccessWithSPNameQualifer() throws ComponentInitializationException {
        this.delegatedAssertion.getSubject().getNameID().setSPNameQualifier("https://portal.example.edu/saml");
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        SubjectCanonicalizationContext c14nContext = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class);
        Assert.assertNotNull((Object)c14nContext);
        Assert.assertNotNull((Object)c14nContext.getSubject());
        Set<NameIDPrincipal> nameIdPrincipals = c14nContext.getSubject().getPrincipals(NameIDPrincipal.class);
        Assert.assertNotNull(nameIdPrincipals);
        Assert.assertEquals((int)nameIdPrincipals.size(), (int)1);
        Assert.assertSame((Object)nameIdPrincipals.iterator().next().getNameID(), (Object)this.delegatedAssertion.getSubject().getNameID());
        Assert.assertEquals((String)c14nContext.getRequesterId(), (String)"https://portal.example.edu/saml");
        Assert.assertEquals((String)c14nContext.getResponderId(), (String)"http://idp.example.org");
    }

    @Test
    public void testSuccessWithSAMLPresenter() throws ComponentInitializationException {
        ((SAMLPresenterEntityContext)this.prc.getInboundMessageContext().getSubcontext(SAMLPresenterEntityContext.class, true)).setEntityId("https://portal.example.edu/saml");
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        SubjectCanonicalizationContext c14nContext = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class);
        Assert.assertNotNull((Object)c14nContext);
        Assert.assertNotNull((Object)c14nContext.getSubject());
        Set<NameIDPrincipal> nameIdPrincipals = c14nContext.getSubject().getPrincipals(NameIDPrincipal.class);
        Assert.assertNotNull(nameIdPrincipals);
        Assert.assertEquals((int)nameIdPrincipals.size(), (int)1);
        Assert.assertSame((Object)nameIdPrincipals.iterator().next().getNameID(), (Object)this.delegatedAssertion.getSubject().getNameID());
        Assert.assertEquals((String)c14nContext.getRequesterId(), (String)"https://portal.example.edu/saml");
        Assert.assertEquals((String)c14nContext.getResponderId(), (String)"http://idp.example.org");
    }

    @Test
    public void testSuccessNoC14NRequester() throws ComponentInitializationException {
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        SubjectCanonicalizationContext c14nContext = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class);
        Assert.assertNotNull((Object)c14nContext);
        Assert.assertNotNull((Object)c14nContext.getSubject());
        Set<NameIDPrincipal> nameIdPrincipals = c14nContext.getSubject().getPrincipals(NameIDPrincipal.class);
        Assert.assertNotNull(nameIdPrincipals);
        Assert.assertEquals((int)nameIdPrincipals.size(), (int)1);
        Assert.assertSame((Object)nameIdPrincipals.iterator().next().getNameID(), (Object)this.delegatedAssertion.getSubject().getNameID());
        Assert.assertNull((Object)c14nContext.getRequesterId());
        Assert.assertEquals((String)c14nContext.getResponderId(), (String)"http://idp.example.org");
    }

    @Test
    public void testNoAssertion() throws ComponentInitializationException {
        this.prc.removeSubcontext(LibertySSOSContext.class);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"NoCredentials");
        SubjectCanonicalizationContext c14nContext = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class);
        Assert.assertNull((Object)c14nContext);
    }

    @Test
    public void testNoSubject() throws ComponentInitializationException {
        ((LibertySSOSContext)this.prc.getSubcontext(LibertySSOSContext.class)).getAttestedToken().setSubject(null);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"InvalidSubject");
        SubjectCanonicalizationContext c14nContext = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class);
        Assert.assertNull((Object)c14nContext);
    }

    @Test
    public void testNoNameID() throws ComponentInitializationException {
        ((LibertySSOSContext)this.prc.getSubcontext(LibertySSOSContext.class)).getAttestedToken().getSubject().setNameID(null);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"InvalidSubject");
        SubjectCanonicalizationContext c14nContext = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class);
        Assert.assertNull((Object)c14nContext);
    }
}

