/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.delegation.messaging.impl;

import javax.xml.namespace.QName;
import net.shibboleth.idp.saml.saml2.profile.delegation.impl.LibertyConstants;
import net.shibboleth.idp.saml.saml2.profile.delegation.messaging.impl.AddSenderHandler;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.openliberty.xmltooling.soapbinding.Sender;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.opensaml.soap.testing.SOAPMessagingBaseTestCase;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddSenderHandlerTest
extends SOAPMessagingBaseTestCase {
    private AddSenderHandler handler;

    @BeforeMethod
    protected void setUp() throws ComponentInitializationException {
        this.handler = new AddSenderHandler();
    }

    @Test
    public void testInputPresentDefaultStrategy() throws ComponentInitializationException, MessageHandlerException {
        ((SAMLSelfEntityContext)this.getMessageContext().getSubcontext(SAMLSelfEntityContext.class, true)).setEntityId("urn:test:foo");
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertFalse((boolean)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)LibertyConstants.SOAP_BINDING_SENDER_ELEMENT_NAME).isEmpty());
        Sender sender = (Sender)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)LibertyConstants.SOAP_BINDING_SENDER_ELEMENT_NAME).get(0);
        Assert.assertEquals((String)sender.getProviderID(), (String)"urn:test:foo");
    }

    @Test
    public void testNoInputDefaultStrategy() throws ComponentInitializationException, MessageHandlerException {
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertTrue((boolean)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)LibertyConstants.SOAP_BINDING_SENDER_ELEMENT_NAME).isEmpty());
    }

    @Test
    public void testInputPresentNonDefaultStrategy() throws ComponentInitializationException, MessageHandlerException {
        ((TestContext)this.getMessageContext().getSubcontext(TestContext.class, (boolean)true)).value = "urn:test:abc123";
        this.handler.setProviderIdLookupFunction(mc -> ((TestContext)mc.getSubcontext(TestContext.class)).value);
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertFalse((boolean)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)LibertyConstants.SOAP_BINDING_SENDER_ELEMENT_NAME).isEmpty());
        Sender sender = (Sender)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)LibertyConstants.SOAP_BINDING_SENDER_ELEMENT_NAME).get(0);
        Assert.assertEquals((String)sender.getProviderID(), (String)"urn:test:abc123");
    }

    public static class TestContext
    extends BaseContext {
        public String value;
    }
}

