/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.delegation.messaging.impl;

import net.shibboleth.idp.saml.saml2.profile.delegation.impl.LibertyConstants;
import net.shibboleth.idp.saml.saml2.profile.delegation.messaging.impl.ProcessSenderHandler;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.openliberty.xmltooling.soapbinding.Sender;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.messaging.context.SAMLPresenterEntityContext;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.opensaml.soap.testing.SOAPMessagingBaseTestCase;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ProcessSenderHandlerTest
extends SOAPMessagingBaseTestCase {
    private ProcessSenderHandler handler;

    @BeforeMethod
    protected void setUp() throws ComponentInitializationException {
        this.handler = new ProcessSenderHandler();
    }

    @Test
    public void testHeaderPresent() throws ComponentInitializationException, MessageHandlerException {
        Sender sender = (Sender)this.buildXMLObject(LibertyConstants.SOAP_BINDING_SENDER_ELEMENT_NAME);
        sender.setProviderID("urn:test:foo");
        SOAPMessagingSupport.addHeaderBlock((MessageContext)this.getMessageContext(), (XMLObject)sender);
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertEquals((String)((SAMLPresenterEntityContext)this.getMessageContext().getSubcontext(SAMLPresenterEntityContext.class, true)).getEntityId(), (String)"urn:test:foo");
        Assert.assertTrue((boolean)SOAPMessagingSupport.checkUnderstoodHeader((MessageContext)this.getMessageContext(), (XMLObject)sender));
    }

    @Test
    public void testHeaderNotPresent() throws ComponentInitializationException, MessageHandlerException {
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertNull((Object)((SAMLPresenterEntityContext)this.getMessageContext().getSubcontext(SAMLPresenterEntityContext.class, true)).getEntityId());
    }

    @Test
    public void testHeaderEmptyValue() throws ComponentInitializationException, MessageHandlerException {
        Sender sender = (Sender)this.buildXMLObject(LibertyConstants.SOAP_BINDING_SENDER_ELEMENT_NAME);
        sender.setProviderID("     ");
        SOAPMessagingSupport.addHeaderBlock((MessageContext)this.getMessageContext(), (XMLObject)sender);
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertNull((Object)((SAMLPresenterEntityContext)this.getMessageContext().getSubcontext(SAMLPresenterEntityContext.class, true)).getEntityId());
        Assert.assertFalse((boolean)SOAPMessagingSupport.checkUnderstoodHeader((MessageContext)this.getMessageContext(), (XMLObject)sender));
    }
}

