/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import java.util.Collection;
import java.util.List;
import net.shibboleth.ext.spring.util.SchemaTypeAwareXMLBeanDefinitionReader;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.idp.attribute.transcoding.impl.AttributeTranscoderRegistryImpl;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.saml2.profile.impl.FilterByQueriedAttributes;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import net.shibboleth.utilities.java.support.test.service.MockReloadableService;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.AttributeQuery;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FilterByQueriedAttributesTest
extends XMLObjectBaseTestCase {
    static final String PATH = "/net/shibboleth/idp/saml/impl/profile/";
    private AttributeQuery query;
    private ReloadableService<AttributeTranscoderRegistry> registry;
    private FilterByQueriedAttributes action;
    private RequestContext rc;
    private ProfileRequestContext prc;

    protected <Type> Type getBean(String fileName, Class<Type> claz) {
        try (GenericApplicationContext context = new GenericApplicationContext();){
            SchemaTypeAwareXMLBeanDefinitionReader beanDefinitionReader = new SchemaTypeAwareXMLBeanDefinitionReader((BeanDefinitionRegistry)context);
            beanDefinitionReader.setValidationMode(3);
            beanDefinitionReader.loadBeanDefinitions(fileName);
            context.refresh();
            Collection beans = context.getBeansOfType(claz).values();
            Assert.assertEquals((int)beans.size(), (int)1);
            Object v = beans.iterator().next();
            return (Type)v;
        }
    }

    @BeforeClass
    public void setup() {
        this.registry = new MockReloadableService((ServiceableComponent)this.getBean("/net/shibboleth/idp/saml/impl/profile/saml2Mapper.xml", AttributeTranscoderRegistryImpl.class));
    }

    @BeforeMethod
    public void setUpMethod() throws ComponentInitializationException, XMLParserException, UnmarshallingException {
        this.query = (AttributeQuery)this.unmarshallElement("/net/shibboleth/idp/saml/impl/profile/AttributeQuery.xml", true);
        this.action = new FilterByQueriedAttributes();
        this.action.setTranscoderRegistry(this.registry);
        this.action.initialize();
        this.rc = new RequestContextBuilder().setInboundMessage((Object)this.query).buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.rc);
    }

    @Test
    public void noAttributes() {
        this.prc.getSubcontext(RelyingPartyContext.class, true);
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void noValues() {
        RelyingPartyContext rpc = (RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class, true);
        AttributeContext ac = (AttributeContext)rpc.getSubcontext(AttributeContext.class, true);
        List<IdPAttribute> attributes = List.of(new IdPAttribute("eduPersonAssurance"), new IdPAttribute("flooby"), new IdPAttribute("eduPersonScopedAffiliation"), new IdPAttribute("eduPersonTargetedID"));
        ac.setIdPAttributes(attributes);
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((int)ac.getIdPAttributes().size(), (int)0);
    }

    @Test
    public void values() {
        RelyingPartyContext rpc = (RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class, true);
        AttributeContext ac = (AttributeContext)rpc.getSubcontext(AttributeContext.class, true);
        IdPAttribute eduPersonAssurance = new IdPAttribute("eduPersonAssurance");
        eduPersonAssurance.setValues(List.of(new StringAttributeValue("green-blue")));
        IdPAttribute flooby = new IdPAttribute("flooby");
        IdPAttribute eduPersonScopedAffiliation = new IdPAttribute("eduPersonScopedAffiliation");
        eduPersonScopedAffiliation.setValues(List.of(new ScopedStringAttributeValue("blue", "yellow")));
        IdPAttribute eduPersonTargetedID = new IdPAttribute("eduPersonTargetedID");
        eduPersonTargetedID.setValues(List.of(new StringAttributeValue("green-blue")));
        List<IdPAttribute> attributes = List.of(eduPersonAssurance, flooby, eduPersonScopedAffiliation, eduPersonTargetedID);
        ac.setIdPAttributes(attributes);
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((int)ac.getIdPAttributes().size(), (int)2);
    }
}

