/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import java.security.Principal;
import java.util.Collections;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.saml2.profile.SAML2ActionTestingSupport;
import net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.idp.saml.saml2.profile.impl.ProcessRequestedAuthnContext;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.core.AuthnContextDeclRef;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockRequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ProcessRequestedAuthnContextTest
extends OpenSAMLInitBaseTestCase {
    private MockRequestContext src;
    private ProfileRequestContext prc;
    private AuthenticationContext ac;
    private ProcessRequestedAuthnContext action;
    private SAMLObjectBuilder<RequestedAuthnContext> racBuilder;
    private SAMLObjectBuilder<AuthnContextClassRef> classBuilder;
    private SAMLObjectBuilder<AuthnContextDeclRef> declBuilder;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.racBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(RequestedAuthnContext.DEFAULT_ELEMENT_NAME);
        this.classBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(AuthnContextClassRef.DEFAULT_ELEMENT_NAME);
        this.declBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(AuthnContextDeclRef.DEFAULT_ELEMENT_NAME);
        this.src = (MockRequestContext)new RequestContextBuilder().buildRequestContext();
        this.prc = (ProfileRequestContext)this.src.getConversationScope().get("opensamlProfileRequestContext");
        this.ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class, true);
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class, true)).setProfileConfig((ProfileConfiguration)new BrowserSSOProfileConfiguration());
        this.action = new ProcessRequestedAuthnContext();
        this.action.initialize();
    }

    @Test
    public void testNoRequest() {
        Event event = this.action.execute((RequestContext)this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidMessageContext");
    }

    @Test
    public void testNoRAC() {
        this.prc.getInboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildAuthnRequest());
        Event event = this.action.execute((RequestContext)this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)this.ac.getSubcontext(RequestedPrincipalContext.class));
    }

    @Test
    public void testEmptyRef() {
        this.prc.getInboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildAuthnRequest());
        RequestedAuthnContext rac = (RequestedAuthnContext)this.racBuilder.buildObject();
        ((AuthnRequest)this.prc.getInboundMessageContext().getMessage()).setRequestedAuthnContext(rac);
        AuthnContextClassRef ref = (AuthnContextClassRef)this.classBuilder.buildObject();
        rac.getAuthnContextClassRefs().add(ref);
        Event event = this.action.execute((RequestContext)this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)this.ac.getSubcontext(RequestedPrincipalContext.class));
    }

    @Test
    public void testDisallowed() {
        this.prc.getInboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildAuthnRequest());
        RequestedAuthnContext rac = (RequestedAuthnContext)this.racBuilder.buildObject();
        ((AuthnRequest)this.prc.getInboundMessageContext().getMessage()).setRequestedAuthnContext(rac);
        AuthnContextClassRef ref = (AuthnContextClassRef)this.classBuilder.buildObject();
        ref.setURI("urn:oasis:names:tc:SAML:2.0:ac:classes:Password");
        rac.getAuthnContextClassRefs().add(ref);
        ((BrowserSSOProfileConfiguration)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getProfileConfig()).setDisallowedFeatures(1);
        Event event = this.action.execute((RequestContext)this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"AccessDenied");
        Assert.assertNull((Object)this.ac.getSubcontext(RequestedPrincipalContext.class));
    }

    @Test
    public void testDisallowedButIgnored() {
        this.prc.getInboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildAuthnRequest());
        RequestedAuthnContext rac = (RequestedAuthnContext)this.racBuilder.buildObject();
        ((AuthnRequest)this.prc.getInboundMessageContext().getMessage()).setRequestedAuthnContext(rac);
        AuthnContextClassRef ref = (AuthnContextClassRef)this.classBuilder.buildObject();
        ref.setURI("urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified");
        rac.getAuthnContextClassRefs().add(ref);
        ((BrowserSSOProfileConfiguration)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getProfileConfig()).setDisallowedFeatures(1);
        Event event = this.action.execute((RequestContext)this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)this.ac.getSubcontext(RequestedPrincipalContext.class));
    }

    @Test
    public void testNoOperator() {
        this.prc.getInboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildAuthnRequest());
        RequestedAuthnContext rac = (RequestedAuthnContext)this.racBuilder.buildObject();
        ((AuthnRequest)this.prc.getInboundMessageContext().getMessage()).setRequestedAuthnContext(rac);
        AuthnContextClassRef ref = (AuthnContextClassRef)this.classBuilder.buildObject();
        ref.setURI("urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
        rac.getAuthnContextClassRefs().add(ref);
        Event event = this.action.execute((RequestContext)this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        RequestedPrincipalContext rpc = (RequestedPrincipalContext)this.ac.getSubcontext(RequestedPrincipalContext.class);
        Assert.assertNotNull((Object)rpc);
        Assert.assertEquals((String)rpc.getOperator(), (String)AuthnContextComparisonTypeEnumeration.EXACT.toString());
        Assert.assertEquals((int)rpc.getRequestedPrincipals().size(), (int)1);
        Assert.assertEquals((String)((Principal)rpc.getRequestedPrincipals().get(0)).getName(), (String)"urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
    }

    @Test
    public void testOperator() {
        this.prc.getInboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildAuthnRequest());
        RequestedAuthnContext rac = (RequestedAuthnContext)this.racBuilder.buildObject();
        ((AuthnRequest)this.prc.getInboundMessageContext().getMessage()).setRequestedAuthnContext(rac);
        rac.setComparison(AuthnContextComparisonTypeEnumeration.MINIMUM);
        AuthnContextClassRef ref = (AuthnContextClassRef)this.classBuilder.buildObject();
        ref.setURI("urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
        rac.getAuthnContextClassRefs().add(ref);
        ref = (AuthnContextClassRef)this.classBuilder.buildObject();
        ref.setURI("urn:oasis:names:tc:SAML:2.0:ac:classes:Kerberos");
        rac.getAuthnContextClassRefs().add(ref);
        Event event = this.action.execute((RequestContext)this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        RequestedPrincipalContext rpc = (RequestedPrincipalContext)this.ac.getSubcontext(RequestedPrincipalContext.class);
        Assert.assertNotNull((Object)rpc);
        Assert.assertEquals((String)rpc.getOperator(), (String)AuthnContextComparisonTypeEnumeration.MINIMUM.toString());
        Assert.assertEquals((int)rpc.getRequestedPrincipals().size(), (int)2);
    }

    @Test
    public void testDecls() {
        this.prc.getInboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildAuthnRequest());
        RequestedAuthnContext rac = (RequestedAuthnContext)this.racBuilder.buildObject();
        ((AuthnRequest)this.prc.getInboundMessageContext().getMessage()).setRequestedAuthnContext(rac);
        rac.setComparison(AuthnContextComparisonTypeEnumeration.MINIMUM);
        AuthnContextDeclRef ref = (AuthnContextDeclRef)this.declBuilder.buildObject();
        ref.setURI("urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
        rac.getAuthnContextDeclRefs().add(ref);
        ref = (AuthnContextDeclRef)this.declBuilder.buildObject();
        ref.setURI("urn:oasis:names:tc:SAML:2.0:ac:classes:Kerberos");
        rac.getAuthnContextDeclRefs().add(ref);
        Event event = this.action.execute((RequestContext)this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        RequestedPrincipalContext rpc = (RequestedPrincipalContext)this.ac.getSubcontext(RequestedPrincipalContext.class);
        Assert.assertNotNull((Object)rpc);
        Assert.assertEquals((String)rpc.getOperator(), (String)AuthnContextComparisonTypeEnumeration.MINIMUM.toString());
        Assert.assertEquals((int)rpc.getRequestedPrincipals().size(), (int)2);
    }

    @Test
    public void testIgnore() {
        this.prc.getInboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildAuthnRequest());
        RequestedAuthnContext rac = (RequestedAuthnContext)this.racBuilder.buildObject();
        ((AuthnRequest)this.prc.getInboundMessageContext().getMessage()).setRequestedAuthnContext(rac);
        AuthnContextClassRef ref = (AuthnContextClassRef)this.classBuilder.buildObject();
        ref.setURI("urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified");
        rac.getAuthnContextClassRefs().add(ref);
        Event event = this.action.execute((RequestContext)this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        RequestedPrincipalContext rpc = (RequestedPrincipalContext)this.ac.getSubcontext(RequestedPrincipalContext.class);
        Assert.assertNull((Object)rpc);
    }

    @Test
    public void testIgnore2() throws ComponentInitializationException {
        this.prc.getInboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildAuthnRequest());
        RequestedAuthnContext rac = (RequestedAuthnContext)this.racBuilder.buildObject();
        ((AuthnRequest)this.prc.getInboundMessageContext().getMessage()).setRequestedAuthnContext(rac);
        AuthnContextClassRef ref = (AuthnContextClassRef)this.classBuilder.buildObject();
        ref.setURI("urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
        rac.getAuthnContextClassRefs().add(ref);
        this.action = new ProcessRequestedAuthnContext();
        this.action.setIgnoredContexts(Collections.singletonList("urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport"));
        this.action.initialize();
        Event event = this.action.execute((RequestContext)this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        RequestedPrincipalContext rpc = (RequestedPrincipalContext)this.ac.getSubcontext(RequestedPrincipalContext.class);
        Assert.assertNull((Object)rpc);
    }
}

