/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.session.impl;

import java.time.Instant;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.session.SAML2SPSession;
import net.shibboleth.idp.saml.session.impl.PrepareInboundMessageContext;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.idp.session.context.LogoutPropagationContext;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.testing.SAML2ActionTestingSupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PrepareInboundMessageContextTest
extends OpenSAMLInitBaseTestCase {
    private RequestContext src;
    private ProfileRequestContext prc;
    private PrepareInboundMessageContext action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        this.prc.setInboundMessageContext(null);
        SAML2SPSession session = new SAML2SPSession("https://sp.example.org", Instant.now(), Instant.now().plusSeconds(1800L), SAML2ActionTestingSupport.buildNameID((String)"jdoe"), "foo", null, true);
        ((LogoutPropagationContext)this.prc.getSubcontext(LogoutPropagationContext.class, true)).setSession((SPSession)session);
        this.action = new PrepareInboundMessageContext();
        this.action.initialize();
    }

    @Test
    public void testNoLogoutPropagationContext() {
        this.prc.removeSubcontext(LogoutPropagationContext.class);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidProfileContext");
        Assert.assertNull((Object)this.prc.getInboundMessageContext());
    }

    @Test
    public void testNoSession() {
        ((LogoutPropagationContext)this.prc.getSubcontext(LogoutPropagationContext.class)).setSession(null);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidProfileContext");
        Assert.assertNull((Object)this.prc.getInboundMessageContext());
    }

    @Test
    public void testSuccess() {
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.prc.getInboundMessageContext());
        SAMLPeerEntityContext ctx = (SAMLPeerEntityContext)this.prc.getInboundMessageContext().getSubcontext(SAMLPeerEntityContext.class);
        Assert.assertNotNull((Object)ctx);
        Assert.assertEquals((String)ctx.getEntityId(), (String)((LogoutPropagationContext)this.prc.getSubcontext(LogoutPropagationContext.class)).getSession().getId());
    }
}

