/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.session.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.Instant;
import javax.xml.namespace.QName;
import net.shibboleth.idp.saml.session.SAML2SPSession;
import net.shibboleth.idp.saml.session.impl.SAML2SPSessionSerializer;
import net.shibboleth.idp.session.SPSession;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.saml2.core.NameID;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SAML2SPSessionSerializerTest
extends OpenSAMLInitBaseTestCase {
    private static final String DATAPATH = "/net/shibboleth/idp/saml/impl/session/";
    private static final Instant INSTANT = Instant.ofEpochMilli(1378827849463L);
    private static final String SESSION_INDEX = "1234567890";
    private static final String CONTEXT = "context";
    private static final String KEY = "key";
    private SAML2SPSessionSerializer serializer;

    @BeforeMethod
    public void setUp() {
        this.serializer = new SAML2SPSessionSerializer(Duration.ofMillis(0L));
    }

    @Test
    public void testInvalid() throws Exception {
        try {
            this.serializer.deserialize(1L, CONTEXT, KEY, this.fileToString("/net/shibboleth/idp/saml/impl/session/noNameID.json"), Long.valueOf(INSTANT.toEpochMilli()));
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.serializer.deserialize(1L, CONTEXT, KEY, this.fileToString("/net/shibboleth/idp/saml/impl/session/noSessionIndex.json"), Long.valueOf(INSTANT.toEpochMilli()));
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.serializer.deserialize(1L, CONTEXT, KEY, this.fileToString("/net/shibboleth/idp/saml/impl/session/invalidXML.json"), Long.valueOf(INSTANT.toEpochMilli()));
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.serializer.deserialize(1L, CONTEXT, KEY, this.fileToString("/net/shibboleth/idp/saml/impl/session/invalidNameID.json"), Long.valueOf(INSTANT.toEpochMilli()));
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testValid() throws Exception {
        Instant exp = INSTANT.plusSeconds(60L);
        NameID nameID = (NameID)XMLObjectSupport.buildXMLObject((QName)NameID.DEFAULT_ELEMENT_NAME);
        nameID.setValue("joe@example.org");
        SAML2SPSession session = new SAML2SPSession("test", INSTANT, exp, nameID, SESSION_INDEX, "https://sp.example.org/acs", false);
        String s = this.serializer.serialize((SPSession)session);
        String s2 = this.fileToString("/net/shibboleth/idp/saml/impl/session/saml2SPSession.json");
        Assert.assertEquals((String)s, (String)s2);
        SAML2SPSession session2 = (SAML2SPSession)this.serializer.deserialize(1L, CONTEXT, KEY, s2, Long.valueOf(exp.toEpochMilli()));
        Assert.assertEquals((String)session.getId(), (String)session2.getId());
        Assert.assertEquals((Object)session.getCreationInstant(), (Object)session2.getCreationInstant());
        Assert.assertEquals((Object)session.getExpirationInstant(), (Object)session2.getExpirationInstant());
        Assert.assertEquals((String)session.getNameID().getValue(), (String)session2.getNameID().getValue());
        Assert.assertEquals((String)session.getSessionIndex(), (String)session2.getSessionIndex());
        Assert.assertFalse((boolean)session2.supportsLogoutPropagation());
    }

    private String fileToString(String pathname) throws URISyntaxException, IOException {
        try (FileInputStream stream = new FileInputStream(new File(SAML2SPSessionSerializerTest.class.getResource(pathname).toURI()));){
            int avail = stream.available();
            byte[] data = new byte[avail];
            int numRead = 0;
            int pos = 0;
            do {
                if (pos + avail > data.length) {
                    byte[] newData = new byte[pos + avail];
                    System.arraycopy(data, 0, newData, 0, pos);
                    data = newData;
                }
                if ((numRead = stream.read(data, pos, avail)) < 0) continue;
                pos += numRead;
            } while ((avail = stream.available()) > 0 && numRead >= 0);
            String string = new String(data, 0, pos, "UTF-8");
            return string;
        }
    }
}

