/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.xmlobject.impl;

import javax.xml.namespace.QName;
import net.shibboleth.idp.saml.xmlobject.KeyAuthority;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class KeyAuthorityTest
extends XMLObjectProviderBaseTestCase {
    private Integer expectedVerifyDepth;
    private int expectedNumKeyInfos;
    private QName unknownAttribName;
    private String unknownAttribValue;

    public KeyAuthorityTest() {
        this.singleElementFile = "/net/shibboleth/idp/saml/impl/xmlobject/ShibMDKeyAuthority.xml";
        this.singleElementOptionalAttributesFile = "/net/shibboleth/idp/saml/impl/xmlobject/ShibMDKeyAuthorityOptionalAttributes.xml";
        this.childElementsFile = "/net/shibboleth/idp/saml/impl/xmlobject/ShibMDKeyAuthorityChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedVerifyDepth = 5;
        this.expectedNumKeyInfos = 4;
        this.unknownAttribName = new QName("http://www.example.org/testObjects", "UnknownAttrib", "test");
        this.unknownAttribValue = "FooBar";
    }

    @Test
    public void testSingleElementMarshall() {
        KeyAuthority keyAuthority = (KeyAuthority)this.buildXMLObject(KeyAuthority.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)keyAuthority);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        KeyAuthority keyAuthority = (KeyAuthority)this.buildXMLObject(KeyAuthority.DEFAULT_ELEMENT_NAME);
        keyAuthority.setVerifyDepth(this.expectedVerifyDepth);
        keyAuthority.getUnknownAttributes().put(this.unknownAttribName, this.unknownAttribValue);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)keyAuthority);
    }

    @Test
    public void testChildElementsMarshall() {
        KeyAuthority keyAuthority = (KeyAuthority)this.buildXMLObject(KeyAuthority.DEFAULT_ELEMENT_NAME);
        for (int i = 0; i < this.expectedNumKeyInfos; ++i) {
            keyAuthority.getKeyInfos().add((KeyInfo)this.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME));
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)keyAuthority);
    }

    @Test
    public void testSingleElementUnmarshall() {
        KeyAuthority keyAuthority = (KeyAuthority)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)keyAuthority, (String)"Unmarshalled object was null");
        Assert.assertNull((Object)keyAuthority.getVerifyDepth(), (String)"VerifyDepth attribute value");
        Assert.assertTrue((boolean)keyAuthority.getUnknownAttributes().isEmpty(), (String)"Extension attribute map was not empty");
        Assert.assertTrue((boolean)keyAuthority.getKeyInfos().isEmpty(), (String)"KeyInfo list was not empty");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        KeyAuthority keyAuthority = (KeyAuthority)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertNotNull((Object)keyAuthority, (String)"Unmarshalled object was null");
        Assert.assertEquals((Object)this.expectedVerifyDepth, (Object)keyAuthority.getVerifyDepth(), (String)"VerifyDepth attribute value");
        Assert.assertFalse((boolean)keyAuthority.getUnknownAttributes().isEmpty(), (String)"Extension attribute map was empty");
        Assert.assertTrue((boolean)keyAuthority.getUnknownAttributes().containsKey((Object)this.unknownAttribName), (String)"AttributeMap did not contain expected unknown attribute name");
        Assert.assertEquals((String)this.unknownAttribValue, (String)keyAuthority.getUnknownAttributes().get((Object)this.unknownAttribName), (String)"AttributeMap did not contain expected unknown attribute value");
        Assert.assertTrue((boolean)keyAuthority.getKeyInfos().isEmpty(), (String)"KeyInfo list was not empty");
    }

    @Test
    public void testChildElementsUnmarshall() {
        KeyAuthority keyAuthority = (KeyAuthority)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)keyAuthority, (String)"Unmarshalled object was null");
        Assert.assertNull((Object)keyAuthority.getVerifyDepth(), (String)"VerifyDepth attribute value");
        Assert.assertTrue((boolean)keyAuthority.getUnknownAttributes().isEmpty(), (String)"Extension attribute map was not empty");
        Assert.assertFalse((boolean)keyAuthority.getKeyInfos().isEmpty(), (String)"KeyInfo list was empty");
        Assert.assertEquals((int)this.expectedNumKeyInfos, (int)keyAuthority.getKeyInfos().size(), (String)"# of KeyInfo child elements");
    }
}

