/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.PairwiseId;
import net.shibboleth.idp.attribute.PairwiseIdStore;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.attribute.impl.JDBCPairwiseIdStore;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.RelyingPartyIdLookupFunction;
import net.shibboleth.idp.profile.context.navigate.ResponderIdLookupFunction;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLException;
import org.opensaml.saml.saml2.profile.AbstractSAML2NameIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafeAfterInit
public class PersistentSAML2NameIDGenerator
extends AbstractSAML2NameIDGenerator {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PersistentSAML2NameIDGenerator.class);
    @Nonnull
    private Function<ProfileRequestContext, SubjectContext> subjectContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy;
    @Nonnull
    @NonnullElements
    private List<String> attributeSourceIds;
    @NonnullAfterInit
    private PairwiseIdStore pidStore;
    @Nullable
    private DataSource dataSource;
    private boolean useUnfilteredAttributes;

    public PersistentSAML2NameIDGenerator() {
        this.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        this.subjectContextLookupStrategy = new ChildContextLookup(SubjectContext.class);
        this.attributeContextLookupStrategy = new ChildContextLookup(AttributeContext.class).compose((Function)new ChildContextLookup(RelyingPartyContext.class));
        this.attributeSourceIds = Collections.emptyList();
        this.setDefaultIdPNameQualifierLookupStrategy((Function)new ResponderIdLookupFunction());
        this.setDefaultSPNameQualifierLookupStrategy((Function)new RelyingPartyIdLookupFunction());
        this.useUnfilteredAttributes = true;
    }

    public void setSubjectContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SubjectContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.subjectContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SubjectContext lookup strategy cannot be null");
    }

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    public void setAttributeSourceIds(@Nonnull @NonnullElements List<String> ids) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributeSourceIds = List.copyOf((Collection)Constraint.isNotNull(ids, (String)"Attribute ID collection cannot be null"));
    }

    public void setPersistentIdStore(@Nullable PairwiseIdStore store) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.pidStore = store;
    }

    public void setDataSource(@Nullable DataSource source) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.dataSource = source;
    }

    public void setUseUnfilteredAttributes(boolean flag) {
        this.useUnfilteredAttributes = flag;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.attributeSourceIds.isEmpty()) {
            throw new ComponentInitializationException("Attribute source ID list cannot be empty");
        }
        if (null == this.pidStore) {
            if (this.dataSource != null) {
                this.log.debug("Creating JDBCPersistentStoreEx instance around supplied DataSource");
                JDBCPairwiseIdStore newStore = new JDBCPairwiseIdStore();
                newStore.setDataSource(this.dataSource);
                newStore.initialize();
                this.pidStore = newStore;
            }
            if (null == this.pidStore) {
                throw new ComponentInitializationException("PairwiseIdStore cannot be null");
            }
        }
    }

    @Nullable
    protected String getIdentifier(@Nonnull ProfileRequestContext profileRequestContext) throws SAMLException {
        String responderId;
        Function lookup = this.getDefaultIdPNameQualifierLookupStrategy();
        String string = responderId = lookup != null ? (String)lookup.apply(profileRequestContext) : null;
        if (responderId == null) {
            this.log.debug("No responder identifier, can't generate persistent ID");
            return null;
        }
        String relyingPartyId = this.getEffectiveSPNameQualifier(profileRequestContext);
        if (relyingPartyId == null) {
            lookup = this.getDefaultSPNameQualifierLookupStrategy();
            String string2 = relyingPartyId = lookup != null ? (String)lookup.apply(profileRequestContext) : null;
        }
        if (relyingPartyId == null) {
            this.log.debug("No relying party identifier, can't generate persistent ID");
            return null;
        }
        SubjectContext subjectCtx = this.subjectContextLookupStrategy.apply(profileRequestContext);
        if (subjectCtx == null || subjectCtx.getPrincipalName() == null) {
            this.log.debug("No principal name, can't generate persistent ID");
            return null;
        }
        AttributeContext attributeCtx = this.attributeContextLookupStrategy.apply(profileRequestContext);
        if (attributeCtx == null) {
            this.log.debug("No attribute context, can't generate persistent ID");
            return null;
        }
        Map attributes = this.useUnfilteredAttributes ? attributeCtx.getUnfilteredIdPAttributes() : attributeCtx.getIdPAttributes();
        for (String sourceId : this.attributeSourceIds) {
            this.log.debug("Checking for source attribute {}", (Object)sourceId);
            IdPAttribute attribute = (IdPAttribute)attributes.get(sourceId);
            if (attribute == null) continue;
            PairwiseId pid = new PairwiseId();
            pid.setIssuerEntityID(responderId);
            pid.setRecipientEntityID(relyingPartyId);
            pid.setPrincipalName(subjectCtx.getPrincipalName());
            List values = attribute.getValues();
            for (IdPAttributeValue value : values) {
                try {
                    if (value instanceof ScopedStringAttributeValue) {
                        this.log.debug("Generating persistent NameID from Scoped String-valued attribute {}", (Object)sourceId);
                        pid.setSourceSystemId(((ScopedStringAttributeValue)value).getValue() + "@" + ((ScopedStringAttributeValue)value).getScope());
                        pid = this.pidStore.getBySourceValue(pid, true);
                        return pid.getPairwiseId();
                    }
                    if (value instanceof StringAttributeValue) {
                        if (StringSupport.trimOrNull((String)((StringAttributeValue)value).getValue()) == null) {
                            this.log.debug("Skipping all-whitespace string value");
                            continue;
                        }
                        this.log.debug("Generating persistent NameID from String-valued attribute {}", (Object)sourceId);
                        pid.setSourceSystemId(((StringAttributeValue)value).getValue());
                        pid = this.pidStore.getBySourceValue(pid, true);
                        return pid.getPairwiseId();
                    }
                    this.log.info("Unrecognized attribute value type: {}", (Object)value.getClass().getName());
                }
                catch (IOException e) {
                    throw new SAMLException((Exception)e);
                }
            }
        }
        this.log.info("Attribute sources {} did not produce a usable source identifier", this.attributeSourceIds);
        return null;
    }
}

