/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.navigate.ResponderIdLookupFunction;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateInboundMessageContextWithSAMLSelf
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateInboundMessageContextWithSAMLSelf.class);
    @Nullable
    private Function<ProfileRequestContext, String> selfIdentityLookupStrategy = new ResponderIdLookupFunction();

    public void setSelfIdentityLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.selfIdentityLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Self identity lookup strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        MessageContext msgCtx = profileRequestContext.getInboundMessageContext();
        SAMLSelfEntityContext selfContext = (SAMLSelfEntityContext)msgCtx.getSubcontext(SAMLSelfEntityContext.class, true);
        selfContext.setEntityId(this.selfIdentityLookupStrategy.apply(profileRequestContext));
        this.log.debug("{} Populated inbound message context with SAML self entityID: {}", (Object)this.getLogPrefix(), (Object)selfContext.getEntityId());
        if (selfContext.getEntityId() == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
        }
    }
}

